/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.db.mongodb;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Sets;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.MongoException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import javax.inject.Inject;
import org.graylog.plugins.pipelineprocessor.db.PipelineStreamConnectionsService;
import org.graylog.plugins.pipelineprocessor.rest.PipelineConnections;
import org.graylog2.bindings.providers.MongoJackObjectMapperProvider;
import org.graylog2.database.MongoConnection;
import org.graylog2.database.NotFoundException;
import org.mongojack.DBCursor;
import org.mongojack.DBQuery;
import org.mongojack.DBSort;
import org.mongojack.JacksonDBCollection;
import org.mongojack.WriteResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoDbPipelineStreamConnectionsService
implements PipelineStreamConnectionsService {
    private static final Logger log = LoggerFactory.getLogger(MongoDbPipelineStreamConnectionsService.class);
    private static final String COLLECTION = "pipeline_processor_pipelines_streams";
    private final JacksonDBCollection<PipelineConnections, String> dbCollection;

    @Inject
    public MongoDbPipelineStreamConnectionsService(MongoConnection mongoConnection, MongoJackObjectMapperProvider mapper) {
        this.dbCollection = JacksonDBCollection.wrap((DBCollection)mongoConnection.getDatabase().getCollection(COLLECTION), PipelineConnections.class, String.class, (ObjectMapper)mapper.get());
        this.dbCollection.createIndex((DBObject)DBSort.asc((String)"stream_id"), (DBObject)new BasicDBObject("unique", (Object)true));
    }

    @Override
    public PipelineConnections save(PipelineConnections connections) {
        PipelineConnections existingConnections = (PipelineConnections)this.dbCollection.findOne(DBQuery.is((String)"stream_id", (Object)connections.streamId()));
        if (existingConnections == null) {
            existingConnections = PipelineConnections.create(null, connections.streamId(), Collections.emptySet());
        }
        PipelineConnections toSave = existingConnections.toBuilder().pipelineIds(connections.pipelineIds()).build();
        WriteResult save = this.dbCollection.save((Object)toSave);
        return (PipelineConnections)save.getSavedObject();
    }

    @Override
    public PipelineConnections load(String streamId) throws NotFoundException {
        PipelineConnections oneById = (PipelineConnections)this.dbCollection.findOne(DBQuery.is((String)"stream_id", (Object)streamId));
        if (oneById == null) {
            throw new NotFoundException("No pipeline connections with for stream " + streamId);
        }
        return oneById;
    }

    @Override
    public Set<PipelineConnections> loadAll() {
        try {
            DBCursor connections = this.dbCollection.find();
            return Sets.newHashSet((Iterator)connections.iterator());
        }
        catch (MongoException e) {
            log.error("Unable to load pipeline connections", (Throwable)e);
            return Collections.emptySet();
        }
    }

    @Override
    public void delete(String streamId) {
        try {
            PipelineConnections connections = this.load(streamId);
            this.dbCollection.removeById((Object)connections.id());
        }
        catch (NotFoundException e) {
            log.debug("No connections found for stream " + streamId);
        }
    }
}

