/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.rest;

import com.google.common.collect.Lists;
import com.google.common.eventbus.EventBus;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.Collection;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.graylog.plugins.pipelineprocessor.ast.Pipeline;
import org.graylog.plugins.pipelineprocessor.db.PipelineDao;
import org.graylog.plugins.pipelineprocessor.db.PipelineService;
import org.graylog.plugins.pipelineprocessor.events.PipelinesChangedEvent;
import org.graylog.plugins.pipelineprocessor.parser.ParseException;
import org.graylog.plugins.pipelineprocessor.parser.PipelineRuleParser;
import org.graylog.plugins.pipelineprocessor.rest.PipelineSource;
import org.graylog2.audit.jersey.AuditEvent;
import org.graylog2.audit.jersey.NoAuditEvent;
import org.graylog2.database.NotFoundException;
import org.graylog2.events.ClusterEventBus;
import org.graylog2.plugin.rest.PluginRestResource;
import org.graylog2.shared.rest.resources.RestResource;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(value="Pipelines/Pipelines", description="Pipelines for the pipeline message processor")
@Path(value="/system/pipelines/pipeline")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@RequiresAuthentication
public class PipelineResource
extends RestResource
implements PluginRestResource {
    private static final Logger log = LoggerFactory.getLogger(PipelineResource.class);
    private final PipelineService pipelineService;
    private final PipelineRuleParser pipelineRuleParser;
    private final EventBus clusterBus;

    @Inject
    public PipelineResource(PipelineService pipelineService, PipelineRuleParser pipelineRuleParser, ClusterEventBus clusterBus) {
        this.pipelineService = pipelineService;
        this.pipelineRuleParser = pipelineRuleParser;
        this.clusterBus = clusterBus;
    }

    @ApiOperation(value="Create a processing pipeline from source", notes="")
    @POST
    @RequiresPermissions(value={"pipeline:create"})
    @AuditEvent(type="pipeline_processor:pipeline:create")
    public PipelineSource createFromParser(@ApiParam(name="pipeline", required=true) @NotNull PipelineSource pipelineSource) throws ParseException {
        Pipeline pipeline;
        try {
            pipeline = this.pipelineRuleParser.parsePipeline(pipelineSource.id(), pipelineSource.source());
        }
        catch (ParseException e) {
            throw new BadRequestException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(e.getErrors()).build());
        }
        PipelineDao pipelineDao = PipelineDao.builder().title(pipeline.name()).description(pipelineSource.description()).source(pipelineSource.source()).createdAt(DateTime.now()).modifiedAt(DateTime.now()).build();
        PipelineDao save = this.pipelineService.save(pipelineDao);
        this.clusterBus.post((Object)PipelinesChangedEvent.updatedPipelineId(save.id()));
        log.debug("Created new pipeline {}", (Object)save);
        return PipelineSource.fromDao(this.pipelineRuleParser, save);
    }

    @ApiOperation(value="Parse a processing pipeline without saving it", notes="")
    @POST
    @Path(value="/parse")
    @NoAuditEvent(value="only used to parse a pipeline, no changes made in the system")
    public PipelineSource parse(@ApiParam(name="pipeline", required=true) @NotNull PipelineSource pipelineSource) throws ParseException {
        Pipeline pipeline;
        try {
            pipeline = this.pipelineRuleParser.parsePipeline(pipelineSource.id(), pipelineSource.source());
        }
        catch (ParseException e) {
            throw new BadRequestException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(e.getErrors()).build());
        }
        return PipelineSource.builder().title(pipeline.name()).description(pipelineSource.description()).source(pipelineSource.source()).createdAt(DateTime.now()).modifiedAt(DateTime.now()).build();
    }

    @ApiOperation(value="Get all processing pipelines")
    @GET
    public Collection<PipelineSource> getAll() {
        Collection<PipelineDao> daos = this.pipelineService.loadAll();
        ArrayList results = Lists.newArrayList();
        for (PipelineDao dao : daos) {
            if (!this.isPermitted("pipeline:read", dao.id())) continue;
            results.add(PipelineSource.fromDao(this.pipelineRuleParser, dao));
        }
        return results;
    }

    @ApiOperation(value="Get a processing pipeline", notes="It can take up to a second until the change is applied")
    @Path(value="/{id}")
    @GET
    public PipelineSource get(@ApiParam(name="id") @PathParam(value="id") String id) throws NotFoundException {
        this.checkPermission("pipeline:read", id);
        PipelineDao dao = this.pipelineService.load(id);
        return PipelineSource.fromDao(this.pipelineRuleParser, dao);
    }

    @ApiOperation(value="Modify a processing pipeline", notes="It can take up to a second until the change is applied")
    @Path(value="/{id}")
    @PUT
    @AuditEvent(type="pipeline_processor:pipeline:update")
    public PipelineSource update(@ApiParam(name="id") @PathParam(value="id") String id, @ApiParam(name="pipeline", required=true) @NotNull PipelineSource update) throws NotFoundException {
        Pipeline pipeline;
        this.checkPermission("pipeline:edit", id);
        PipelineDao dao = this.pipelineService.load(id);
        try {
            pipeline = this.pipelineRuleParser.parsePipeline(update.id(), update.source());
        }
        catch (ParseException e) {
            throw new BadRequestException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(e.getErrors()).build());
        }
        PipelineDao toSave = dao.toBuilder().title(pipeline.name()).description(update.description()).source(update.source()).modifiedAt(DateTime.now()).build();
        PipelineDao savedPipeline = this.pipelineService.save(toSave);
        this.clusterBus.post((Object)PipelinesChangedEvent.updatedPipelineId(savedPipeline.id()));
        return PipelineSource.fromDao(this.pipelineRuleParser, savedPipeline);
    }

    @ApiOperation(value="Delete a processing pipeline", notes="It can take up to a second until the change is applied")
    @Path(value="/{id}")
    @DELETE
    @AuditEvent(type="pipeline_processor:pipeline:delete")
    public void delete(@ApiParam(name="id") @PathParam(value="id") String id) throws NotFoundException {
        this.checkPermission("pipeline:delete", id);
        this.pipelineService.load(id);
        this.pipelineService.delete(id);
        this.clusterBus.post((Object)PipelinesChangedEvent.deletedPipelineId(id));
    }
}

