/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.processors;

import com.codahale.metrics.MetricRegistry;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.tools.ToolProvider;
import org.graylog.plugins.pipelineprocessor.ast.Pipeline;
import org.graylog.plugins.pipelineprocessor.ast.Rule;
import org.graylog.plugins.pipelineprocessor.codegen.PipelineClassloader;
import org.graylog.plugins.pipelineprocessor.db.PipelineService;
import org.graylog.plugins.pipelineprocessor.db.PipelineStreamConnectionsService;
import org.graylog.plugins.pipelineprocessor.db.RuleService;
import org.graylog.plugins.pipelineprocessor.events.PipelineConnectionsChangedEvent;
import org.graylog.plugins.pipelineprocessor.events.PipelinesChangedEvent;
import org.graylog.plugins.pipelineprocessor.events.RulesChangedEvent;
import org.graylog.plugins.pipelineprocessor.parser.FunctionRegistry;
import org.graylog.plugins.pipelineprocessor.parser.ParseException;
import org.graylog.plugins.pipelineprocessor.parser.PipelineRuleParser;
import org.graylog.plugins.pipelineprocessor.processors.PipelineInterpreter;
import org.graylog.plugins.pipelineprocessor.rest.PipelineConnections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ConfigurationStateUpdater {
    private static final Logger log = LoggerFactory.getLogger(ConfigurationStateUpdater.class);
    private final RuleService ruleService;
    private final PipelineService pipelineService;
    private final PipelineStreamConnectionsService pipelineStreamConnectionsService;
    private final PipelineRuleParser pipelineRuleParser;
    private final MetricRegistry metricRegistry;
    private final FunctionRegistry functionRegistry;
    private final ScheduledExecutorService scheduler;
    private final EventBus serverEventBus;
    private final PipelineInterpreter.State.Factory stateFactory;
    private final AtomicReference<PipelineInterpreter.State> latestState = new AtomicReference();
    private static boolean allowCodeGeneration = false;

    @Inject
    public ConfigurationStateUpdater(RuleService ruleService, PipelineService pipelineService, PipelineStreamConnectionsService pipelineStreamConnectionsService, PipelineRuleParser pipelineRuleParser, MetricRegistry metricRegistry, FunctionRegistry functionRegistry, @Named(value="daemonScheduler") ScheduledExecutorService scheduler, EventBus serverEventBus, PipelineInterpreter.State.Factory stateFactory, @Named(value="generate_native_code") boolean allowCodeGeneration) {
        this.ruleService = ruleService;
        this.pipelineService = pipelineService;
        this.pipelineStreamConnectionsService = pipelineStreamConnectionsService;
        this.pipelineRuleParser = pipelineRuleParser;
        this.metricRegistry = metricRegistry;
        this.functionRegistry = functionRegistry;
        this.scheduler = scheduler;
        this.serverEventBus = serverEventBus;
        this.stateFactory = stateFactory;
        ConfigurationStateUpdater.setAllowCodeGeneration(false);
        serverEventBus.register((Object)this);
        this.reloadAndSave();
    }

    private static void setAllowCodeGeneration(Boolean allowCodeGeneration) {
        if (allowCodeGeneration.booleanValue() && ToolProvider.getSystemJavaCompiler() == null) {
            log.warn("Your Java runtime does not have a compiler available, turning off dynamic code generation. Please consider running Graylog in a JDK, not a JRE, to avoid a performance penalty in pipeline processing.");
            allowCodeGeneration = false;
        }
        ConfigurationStateUpdater.allowCodeGeneration = allowCodeGeneration;
    }

    public static boolean isAllowCodeGeneration() {
        return allowCodeGeneration;
    }

    private synchronized PipelineInterpreter.State reloadAndSave() {
        PipelineClassloader commonClassLoader = allowCodeGeneration ? new PipelineClassloader() : null;
        HashMap ruleNameMap = Maps.newHashMap();
        this.ruleService.loadAll().forEach(ruleDao -> {
            Rule rule;
            try {
                rule = this.pipelineRuleParser.parseRule(ruleDao.id(), ruleDao.source(), false, commonClassLoader);
            }
            catch (ParseException e) {
                rule = Rule.alwaysFalse("Failed to parse rule: " + ruleDao.id());
            }
            ruleNameMap.put(rule.name(), rule);
        });
        ImmutableMap.Builder pipelineIdMap = ImmutableMap.builder();
        this.pipelineService.loadAll().forEach(pipelineDao -> {
            Pipeline pipeline;
            try {
                pipeline = this.pipelineRuleParser.parsePipeline(pipelineDao.id(), pipelineDao.source());
            }
            catch (ParseException e) {
                pipeline = Pipeline.empty("Failed to parse pipeline" + pipelineDao.id());
            }
            pipelineIdMap.put((Object)pipelineDao.id(), (Object)this.resolvePipeline(pipeline, ruleNameMap));
        });
        ImmutableMap currentPipelines = pipelineIdMap.build();
        HashMultimap connections = HashMultimap.create();
        for (PipelineConnections streamConnection : this.pipelineStreamConnectionsService.loadAll()) {
            streamConnection.pipelineIds().stream().map(arg_0 -> ((ImmutableMap)currentPipelines).get(arg_0)).filter(Objects::nonNull).forEach(pipeline -> connections.put((Object)streamConnection.streamId(), pipeline));
        }
        ImmutableSetMultimap streamPipelineConnections = ImmutableSetMultimap.copyOf((Multimap)connections);
        PipelineInterpreter.State newState = this.stateFactory.newState((ImmutableMap<String, Pipeline>)currentPipelines, (ImmutableSetMultimap<String, Pipeline>)streamPipelineConnections);
        this.latestState.set(newState);
        return newState;
    }

    public PipelineInterpreter.State getLatestState() {
        return this.latestState.get();
    }

    @Nonnull
    private Pipeline resolvePipeline(Pipeline pipeline, Map<String, Rule> ruleNameMap) {
        log.debug("Resolving pipeline {}", (Object)pipeline.name());
        pipeline.stages().forEach(stage -> {
            List<Rule> resolvedRules = stage.ruleReferences().stream().map(ref -> {
                Rule rule = (Rule)ruleNameMap.get(ref);
                if (rule == null) {
                    rule = Rule.alwaysFalse("Unresolved rule " + ref);
                }
                rule = rule.invokableCopy(this.functionRegistry);
                log.debug("Resolved rule `{}` to {}", ref, (Object)rule);
                rule.registerMetrics(this.metricRegistry, pipeline.id(), String.valueOf(stage.stage()));
                return rule;
            }).collect(Collectors.toList());
            stage.setRules(resolvedRules);
            stage.setPipeline(pipeline);
            stage.registerMetrics(this.metricRegistry, pipeline.id());
        });
        pipeline.registerMetrics(this.metricRegistry);
        return pipeline;
    }

    @Subscribe
    public void handleRuleChanges(RulesChangedEvent event) {
        event.deletedRuleIds().forEach(id -> {
            log.debug("Invalidated rule {}", id);
            this.metricRegistry.removeMatching((name, metric) -> name.startsWith(MetricRegistry.name(Rule.class, (String[])new String[]{id})));
        });
        event.updatedRuleIds().forEach(id -> log.debug("Refreshing rule {}", id));
        this.scheduler.schedule(() -> this.serverEventBus.post((Object)this.reloadAndSave()), 0L, TimeUnit.SECONDS);
    }

    @Subscribe
    public void handlePipelineChanges(PipelinesChangedEvent event) {
        event.deletedPipelineIds().forEach(id -> {
            log.debug("Invalidated pipeline {}", id);
            this.metricRegistry.removeMatching((name, metric) -> name.startsWith(MetricRegistry.name(Pipeline.class, (String[])new String[]{id})));
        });
        event.updatedPipelineIds().forEach(id -> log.debug("Refreshing pipeline {}", id));
        this.scheduler.schedule(() -> this.serverEventBus.post((Object)this.reloadAndSave()), 0L, TimeUnit.SECONDS);
    }

    @Subscribe
    public void handlePipelineConnectionChanges(PipelineConnectionsChangedEvent event) {
        log.debug("Pipeline stream connection changed: {}", (Object)event);
        this.scheduler.schedule(() -> this.serverEventBus.post((Object)this.reloadAndSave()), 0L, TimeUnit.SECONDS);
    }

    @VisibleForTesting
    PipelineInterpreter.State reload() {
        return this.reloadAndSave();
    }
}

