/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.functions.messages;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SortedSetMultimap;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.google.common.util.concurrent.AbstractIdleService;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.graylog2.database.NotFoundException;
import org.graylog2.plugin.database.Persisted;
import org.graylog2.plugin.streams.Stream;
import org.graylog2.streams.StreamService;
import org.graylog2.streams.events.StreamsChangedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class StreamCacheService
extends AbstractIdleService {
    private static final Logger LOG = LoggerFactory.getLogger(StreamCacheService.class);
    private final EventBus eventBus;
    private final StreamService streamService;
    private final ScheduledExecutorService executorService;
    private final SortedSetMultimap<String, Stream> nameToStream = Multimaps.synchronizedSortedSetMultimap((SortedSetMultimap)MultimapBuilder.hashKeys().treeSetValues(Comparator.comparing(Persisted::getId)).build());
    private final Map<String, Stream> idToStream = Maps.newConcurrentMap();

    @Inject
    public StreamCacheService(EventBus eventBus, StreamService streamService, @Named(value="daemonScheduler") ScheduledExecutorService executorService) {
        this.eventBus = eventBus;
        this.streamService = streamService;
        this.executorService = executorService;
    }

    protected void startUp() throws Exception {
        this.streamService.loadAllEnabled().forEach(this::updateCache);
        this.eventBus.register((Object)this);
    }

    protected void shutDown() throws Exception {
        this.eventBus.unregister((Object)this);
    }

    @Subscribe
    public void handleStreamUpdate(StreamsChangedEvent event) {
        this.executorService.schedule(() -> this.updateStreams((Collection<String>)event.streamIds()), 0L, TimeUnit.SECONDS);
    }

    @VisibleForTesting
    public void updateStreams(Collection<String> ids) {
        for (String id : ids) {
            LOG.debug("Updating stream id/title cache for id {}", (Object)id);
            try {
                Stream stream = this.streamService.load(id);
                if (stream.getDisabled().booleanValue()) {
                    this.purgeCache(stream.getId());
                    continue;
                }
                this.updateCache(stream);
            }
            catch (NotFoundException e) {
                this.purgeCache(id);
            }
        }
    }

    private void purgeCache(String id) {
        Stream stream = this.idToStream.remove(id);
        LOG.debug("Purging stream id/title cache for id {}, stream {}", (Object)id, (Object)stream);
        if (stream != null) {
            this.nameToStream.remove((Object)stream.getTitle(), (Object)stream);
        }
    }

    private void updateCache(Stream stream) {
        LOG.debug("Updating stream id/title cache for {}/'{}'", (Object)stream.getId(), (Object)stream.getTitle());
        this.idToStream.put(stream.getId(), stream);
        this.nameToStream.put((Object)stream.getTitle(), (Object)stream);
    }

    public Collection<Stream> getByName(String name) {
        return this.nameToStream.get((Object)name);
    }

    @Nullable
    public Stream getById(String id) {
        return this.idToStream.get(id);
    }
}

