/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.ast.expressions;

import com.google.common.base.Joiner;
import java.util.Map;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.Token;
import org.graylog.plugins.pipelineprocessor.EvaluationContext;
import org.graylog.plugins.pipelineprocessor.ast.exceptions.FunctionEvaluationException;
import org.graylog.plugins.pipelineprocessor.ast.exceptions.LocationAwareEvalException;
import org.graylog.plugins.pipelineprocessor.ast.expressions.BaseExpression;
import org.graylog.plugins.pipelineprocessor.ast.expressions.Expression;
import org.graylog.plugins.pipelineprocessor.ast.functions.Function;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionArgs;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionDescriptor;

public class FunctionExpression
extends BaseExpression {
    private final FunctionArgs args;
    private final Function<?> function;
    private final FunctionDescriptor descriptor;

    public FunctionExpression(Token start, FunctionArgs args) {
        super(start);
        this.args = args;
        this.function = args.getFunction();
        this.descriptor = this.function.descriptor();
        this.function.preprocessArgs(args);
    }

    public Function<?> getFunction() {
        return this.function;
    }

    public FunctionArgs getArgs() {
        return this.args;
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    @Override
    public Object evaluateUnsafe(EvaluationContext context) {
        try {
            return this.descriptor.returnType().cast(this.function.evaluate(this.args, context));
        }
        catch (LocationAwareEvalException laee) {
            throw laee;
        }
        catch (Exception e) {
            throw new FunctionEvaluationException(this, e);
        }
    }

    @Override
    public Class getType() {
        return this.descriptor.returnType();
    }

    public String toString() {
        String argsString = "";
        if (this.args != null) {
            argsString = Joiner.on((String)", ").withKeyValueSeparator(": ").join(this.args.getArgs().entrySet().stream().sorted((e1, e2) -> ((String)e1.getKey()).compareTo((String)e2.getKey())).iterator());
        }
        return this.descriptor.name() + "(" + argsString + ")";
    }

    @Override
    public Iterable<Expression> children() {
        return this.args.getArgs().entrySet().stream().map(Map.Entry::getValue).collect(Collectors.toList());
    }
}

