/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.ast.expressions;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.Token;
import org.graylog.plugins.pipelineprocessor.EvaluationContext;
import org.graylog.plugins.pipelineprocessor.ast.expressions.BaseExpression;
import org.graylog.plugins.pipelineprocessor.ast.expressions.Expression;

public class ArrayLiteralExpression
extends BaseExpression {
    private final List<Expression> elements;

    public ArrayLiteralExpression(Token start, List<Expression> elements) {
        super(start);
        this.elements = elements;
    }

    @Override
    public boolean isConstant() {
        return this.elements.stream().allMatch(Expression::isConstant);
    }

    @Override
    public List evaluateUnsafe(EvaluationContext context) {
        return this.elements.stream().map(expression -> expression.evaluateUnsafe(context)).collect(Collectors.toList());
    }

    @Override
    public Class getType() {
        return List.class;
    }

    public String toString() {
        return "[" + Joiner.on((String)", ").join(this.elements) + "]";
    }

    @Override
    public Iterable<Expression> children() {
        return ImmutableList.copyOf(this.elements);
    }
}

