/*
 * Decompiled with CFR 0.152.
 */
package de.hilling.graylog.plugins.multimatch;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.graylog.plugins.pipelineprocessor.ast.functions.Function;
import org.graylog2.plugin.Message;

class MultiMatcher {
    private static final String MESSAGE_KEY = "message";
    private final List<Map<String, String>> matchers;
    private final Message message;
    private final Cache<String, Pattern> patternCache = Caffeine.newBuilder().maximumSize(2000L).build();

    MultiMatcher(@Nonnull List<Map<String, String>> matchers, @Nonnull Message message) {
        this.matchers = matchers;
        this.message = message;
    }

    boolean invoke() {
        if (!this.typesCorrect(this.matchers)) {
            Function.log.error("wrong type of configuration, expecting a list of maps");
            return false;
        }
        return this.matchers.stream().anyMatch(this::matchAllMapPredicates);
    }

    private boolean typesCorrect(List<?> matchers) {
        return matchers.stream().allMatch(this::assertStringMap);
    }

    private boolean assertStringMap(Object o) {
        if (o instanceof Map) {
            Map map = (Map)o;
            return map.entrySet().stream().allMatch(this::assertStrings);
        }
        return false;
    }

    private boolean assertStrings(Map.Entry entry) {
        return entry.getKey() instanceof String && entry.getValue() instanceof String;
    }

    private boolean matchAllMapPredicates(Map<String, String> map) {
        Function.log.debug("found object {}/{}", map, map.getClass());
        return map.entrySet().stream().allMatch(this::match);
    }

    private boolean match(Map.Entry<String, String> mapEntry) {
        String key = mapEntry.getKey();
        String matcherString = mapEntry.getValue();
        if (!this.message.hasField(key)) {
            return false;
        }
        if (Objects.equals(key, MESSAGE_KEY)) {
            return this.matchMessage(matcherString);
        }
        return Objects.equals(matcherString, this.message.getField(key));
    }

    private Pattern fromCache(String matcherString) {
        return this.patternCache.get(matcherString, t -> Pattern.compile(matcherString, 40));
    }

    private boolean matchMessage(String matcherString) {
        String messageField = (String)this.message.getFieldAs(String.class, MESSAGE_KEY);
        return this.fromCache(matcherString).matcher(messageField).matches();
    }
}

