/*
 * Decompiled with CFR 0.152.
 */
package de.hilling.graylog.plugins.multimatch;

import com.google.common.collect.ImmutableList;
import de.hilling.graylog.plugins.multimatch.MultiMatcher;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.graylog.plugins.pipelineprocessor.EvaluationContext;
import org.graylog.plugins.pipelineprocessor.ast.expressions.Expression;
import org.graylog.plugins.pipelineprocessor.ast.functions.Function;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionArgs;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionDescriptor;
import org.graylog.plugins.pipelineprocessor.ast.functions.ParameterDescriptor;
import org.graylog2.plugin.Message;

public class MultiMatchFunction
implements Function<Boolean> {
    public static final String NAME = "multimatch";
    private static final String MESSAGE_PARAM = "message";
    private static final String MATCHER_PARAM = "matcherMap";
    private final ParameterDescriptor<Message, Message> messageParam = ParameterDescriptor.type("message", Message.class).optional().description("The message to verify, defaults to '$message'").build();
    private final ParameterDescriptor<Map, Map> matcherParam = ParameterDescriptor.type("matcherMap", Map.class).description("The map conditions to evaluate").build();

    @Override
    public Object preComputeConstantArgument(FunctionArgs functionArgs, String s, Expression expression) {
        return expression.evaluateUnsafe(EvaluationContext.emptyContext());
    }

    @Override
    public Boolean evaluate(FunctionArgs args, EvaluationContext context) {
        Message message = this.messageParam.optional(args, context).orElse(context.currentMessage());
        Map matcherParams = this.matcherParam.optional(args, context).orElse(Collections.emptyMap());
        log.debug("message {}", (Object)message);
        List matchers = (List)matcherParams.get("value");
        if (matchers == null) {
            return false;
        }
        return new MultiMatcher(matchers, message).invoke();
    }

    @Override
    public FunctionDescriptor<Boolean> descriptor() {
        return FunctionDescriptor.builder().name(NAME).description("Matches multiple fields of the message to multiple conditions").params((ImmutableList<ParameterDescriptor>)ImmutableList.of(this.messageParam, this.matcherParam)).returnType(Boolean.class).build();
    }
}

