/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.processors;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ArrayListMultimap;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import org.graylog.plugins.pipelineprocessor.ast.Pipeline;
import org.graylog.plugins.pipelineprocessor.ast.Stage;

public class StageIterator
extends AbstractIterator<List<Stage>> {
    private final Configuration config;
    private int currentStage;

    public StageIterator(Configuration config) {
        this.config = config;
        this.currentStage = config.initialStage();
    }

    public StageIterator(Set<Pipeline> pipelines) {
        this.config = new Configuration(pipelines);
        this.currentStage = this.config.initialStage();
    }

    protected List<Stage> computeNext() {
        if (this.currentStage == this.config.lastStage()) {
            return (List)this.endOfData();
        }
        do {
            ++this.currentStage;
            if (this.currentStage <= this.config.lastStage()) continue;
            return (List)this.endOfData();
        } while (!this.config.hasStages(this.currentStage));
        return this.config.getStages(this.currentStage);
    }

    public static class Configuration {
        private final int[] extent = new int[]{Integer.MAX_VALUE, Integer.MIN_VALUE};
        private final ArrayListMultimap<Integer, Stage> stageMultimap = ArrayListMultimap.create();
        private final int initialStage;

        public Configuration(Set<Pipeline> pipelines) {
            if (pipelines.isEmpty()) {
                this.extent[1] = 0;
                this.extent[0] = 0;
                this.initialStage = 0;
                return;
            }
            pipelines.forEach(pipeline -> {
                SortedSet<Stage> stages = pipeline.stages();
                if (stages.isEmpty()) {
                    return;
                }
                this.extent[0] = Math.min(this.extent[0], stages.first().stage());
                this.extent[1] = Math.max(this.extent[1], stages.last().stage());
                stages.forEach(stage -> this.stageMultimap.put((Object)stage.stage(), stage));
            });
            if (this.extent[0] == Integer.MIN_VALUE) {
                throw new IllegalArgumentException("First stage cannot be at -2147483648");
            }
            this.initialStage = this.extent[0] - 1;
        }

        public int initialStage() {
            return this.initialStage;
        }

        public int lastStage() {
            return this.extent[1];
        }

        public boolean hasStages(int stage) {
            return this.stageMultimap.containsKey((Object)stage);
        }

        public List<Stage> getStages(int stage) {
            return this.stageMultimap.get((Object)stage);
        }
    }
}

