/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.ast.functions;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.graylog.plugins.pipelineprocessor.ast.expressions.Expression;
import org.graylog.plugins.pipelineprocessor.ast.expressions.VarRefExpression;
import org.graylog.plugins.pipelineprocessor.ast.functions.Function;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionDescriptor;
import org.graylog.plugins.pipelineprocessor.ast.functions.ParameterDescriptor;

public class FunctionArgs {
    @Nonnull
    private final Map<String, Expression> args;
    private final Map<String, Object> constantValues = Maps.newHashMap();
    private final Function function;
    private final FunctionDescriptor descriptor;

    public FunctionArgs(Function func, Map<String, Expression> args) {
        this.function = func;
        this.descriptor = this.function.descriptor();
        this.args = (Map)MoreObjects.firstNonNull(args, Collections.emptyMap());
    }

    @Nonnull
    public Map<String, Expression> getArgs() {
        return this.args;
    }

    @Nonnull
    public Map<String, Expression> getConstantArgs() {
        return this.args.entrySet().stream().filter(e -> e != null && e.getValue() != null && ((Expression)e.getValue()).isConstant()).filter(e -> !(e.getValue() instanceof VarRefExpression)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public boolean isPresent(String key) {
        return this.args.containsKey(key);
    }

    @Nullable
    public Expression expression(String key) {
        return this.args.get(key);
    }

    public Object getPreComputedValue(String name) {
        return this.constantValues.get(name);
    }

    public void setPreComputedValue(@Nonnull String name, @Nonnull Object value) {
        Objects.requireNonNull(value);
        this.constantValues.put(name, value);
    }

    public Function<?> getFunction() {
        return this.function;
    }

    public ParameterDescriptor<?, ?> param(String name) {
        return this.descriptor.param(name);
    }
}

