/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.simulator;

import com.google.common.base.Stopwatch;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.graylog.plugins.pipelineprocessor.simulator.PipelineInterpreterTrace;
import org.graylog.plugins.pipelineprocessor.simulator.SimulatorInterpreterListener;

public class PipelineInterpreterTracer {
    private final List<PipelineInterpreterTrace> executionTrace = new ArrayList<PipelineInterpreterTrace>();
    private final Stopwatch timer = Stopwatch.createUnstarted();
    private final SimulatorInterpreterListener simulatorInterpreterListener = new SimulatorInterpreterListener(this);

    public SimulatorInterpreterListener getSimulatorInterpreterListener() {
        return this.simulatorInterpreterListener;
    }

    public List<PipelineInterpreterTrace> getExecutionTrace() {
        return this.executionTrace;
    }

    public long took() {
        return this.timer.elapsed(TimeUnit.MICROSECONDS);
    }

    public void addTrace(String message) {
        this.executionTrace.add(PipelineInterpreterTrace.create(this.timer.elapsed(TimeUnit.MICROSECONDS), message));
    }

    public void startProcessing(String message) {
        this.timer.start();
        this.addTrace(message);
    }

    public void finishProcessing(String message) {
        this.timer.stop();
        this.addTrace(message);
    }
}

