/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.rest;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.graylog.plugins.pipelineprocessor.parser.errors.ParseError;
import org.graylog.plugins.pipelineprocessor.rest.PipelineSource;
import org.graylog.plugins.pipelineprocessor.rest.StageSource;
import org.joda.time.DateTime;
import org.mongojack.Id;
import org.mongojack.ObjectId;

final class AutoValue_PipelineSource
extends PipelineSource {
    private final String id;
    private final String title;
    private final String description;
    private final String source;
    private final DateTime createdAt;
    private final DateTime modifiedAt;
    private final List<StageSource> stages;
    private final Set<ParseError> errors;

    private AutoValue_PipelineSource(@Nullable String id, @Nullable String title, @Nullable String description, String source, @Nullable DateTime createdAt, @Nullable DateTime modifiedAt, List<StageSource> stages, @Nullable Set<ParseError> errors) {
        this.id = id;
        this.title = title;
        this.description = description;
        this.source = source;
        this.createdAt = createdAt;
        this.modifiedAt = modifiedAt;
        this.stages = stages;
        this.errors = errors;
    }

    @Override
    @JsonProperty(value="id")
    @Nullable
    @Id
    @ObjectId
    public String id() {
        return this.id;
    }

    @Override
    @JsonProperty(value="title")
    @Nullable
    public String title() {
        return this.title;
    }

    @Override
    @JsonProperty(value="description")
    @Nullable
    public String description() {
        return this.description;
    }

    @Override
    @JsonProperty(value="source")
    public String source() {
        return this.source;
    }

    @Override
    @JsonProperty(value="created_at")
    @Nullable
    public DateTime createdAt() {
        return this.createdAt;
    }

    @Override
    @JsonProperty(value="modified_at")
    @Nullable
    public DateTime modifiedAt() {
        return this.modifiedAt;
    }

    @Override
    @JsonProperty(value="stages")
    public List<StageSource> stages() {
        return this.stages;
    }

    @Override
    @JsonProperty(value="errors")
    @Nullable
    public Set<ParseError> errors() {
        return this.errors;
    }

    public String toString() {
        return "PipelineSource{id=" + this.id + ", title=" + this.title + ", description=" + this.description + ", source=" + this.source + ", createdAt=" + this.createdAt + ", modifiedAt=" + this.modifiedAt + ", stages=" + this.stages + ", errors=" + this.errors + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof PipelineSource) {
            PipelineSource that = (PipelineSource)o;
            return (this.id == null ? that.id() == null : this.id.equals(that.id())) && (this.title == null ? that.title() == null : this.title.equals(that.title())) && (this.description == null ? that.description() == null : this.description.equals(that.description())) && this.source.equals(that.source()) && (this.createdAt == null ? that.createdAt() == null : this.createdAt.equals((Object)that.createdAt())) && (this.modifiedAt == null ? that.modifiedAt() == null : this.modifiedAt.equals((Object)that.modifiedAt())) && this.stages.equals(that.stages()) && (this.errors == null ? that.errors() == null : this.errors.equals(that.errors()));
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.id == null ? 0 : this.id.hashCode();
        h *= 1000003;
        h ^= this.title == null ? 0 : this.title.hashCode();
        h *= 1000003;
        h ^= this.description == null ? 0 : this.description.hashCode();
        h *= 1000003;
        h ^= this.source.hashCode();
        h *= 1000003;
        h ^= this.createdAt == null ? 0 : this.createdAt.hashCode();
        h *= 1000003;
        h ^= this.modifiedAt == null ? 0 : this.modifiedAt.hashCode();
        h *= 1000003;
        h ^= this.stages.hashCode();
        h *= 1000003;
        return h ^= this.errors == null ? 0 : this.errors.hashCode();
    }

    @Override
    public PipelineSource.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends PipelineSource.Builder {
        private String id;
        private String title;
        private String description;
        private String source;
        private DateTime createdAt;
        private DateTime modifiedAt;
        private List<StageSource> stages;
        private Set<ParseError> errors;

        Builder() {
        }

        private Builder(PipelineSource source) {
            this.id = source.id();
            this.title = source.title();
            this.description = source.description();
            this.source = source.source();
            this.createdAt = source.createdAt();
            this.modifiedAt = source.modifiedAt();
            this.stages = source.stages();
            this.errors = source.errors();
        }

        @Override
        public PipelineSource.Builder id(@Nullable String id) {
            this.id = id;
            return this;
        }

        @Override
        public PipelineSource.Builder title(@Nullable String title) {
            this.title = title;
            return this;
        }

        @Override
        public PipelineSource.Builder description(@Nullable String description) {
            this.description = description;
            return this;
        }

        @Override
        public PipelineSource.Builder source(String source) {
            if (source == null) {
                throw new NullPointerException("Null source");
            }
            this.source = source;
            return this;
        }

        @Override
        public PipelineSource.Builder createdAt(@Nullable DateTime createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Override
        public PipelineSource.Builder modifiedAt(@Nullable DateTime modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        @Override
        public PipelineSource.Builder stages(List<StageSource> stages) {
            if (stages == null) {
                throw new NullPointerException("Null stages");
            }
            this.stages = stages;
            return this;
        }

        @Override
        public PipelineSource.Builder errors(@Nullable Set<ParseError> errors) {
            this.errors = errors;
            return this;
        }

        @Override
        public PipelineSource build() {
            String missing = "";
            if (this.source == null) {
                missing = missing + " source";
            }
            if (this.stages == null) {
                missing = missing + " stages";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_PipelineSource(this.id, this.title, this.description, this.source, this.createdAt, this.modifiedAt, this.stages, this.errors);
        }
    }
}

