/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.functions.urls;

import com.google.common.base.Throwables;
import java.net.MalformedURLException;
import java.util.Optional;
import org.graylog.plugins.pipelineprocessor.EvaluationContext;
import org.graylog.plugins.pipelineprocessor.ast.functions.AbstractFunction;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionArgs;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionDescriptor;
import org.graylog.plugins.pipelineprocessor.ast.functions.ParameterDescriptor;
import org.graylog.plugins.pipelineprocessor.functions.urls.URL;

public class UrlConversion
extends AbstractFunction<URL> {
    public static final String NAME = "to_url";
    private final ParameterDescriptor<Object, Object> urlParam = ParameterDescriptor.object("url").description("Value to convert").build();
    private final ParameterDescriptor<String, String> defaultParam = ParameterDescriptor.string("default").optional().description("Used when 'url' is null or malformed").build();

    @Override
    public URL evaluate(FunctionArgs args, EvaluationContext context) {
        String urlString = String.valueOf(this.urlParam.required(args, context));
        try {
            return new URL(urlString);
        }
        catch (IllegalArgumentException | MalformedURLException e) {
            log.debug("Unable to parse URL for string {}", (Object)urlString, (Object)e);
            Optional<String> defaultUrl = this.defaultParam.optional(args, context);
            if (!defaultUrl.isPresent()) {
                return null;
            }
            try {
                return new URL(defaultUrl.get());
            }
            catch (IllegalArgumentException | MalformedURLException e1) {
                log.warn("Parameter `default` for to_url() is not a valid URL: {}", (Object)defaultUrl.get());
                throw Throwables.propagate((Throwable)e1);
            }
        }
    }

    @Override
    public FunctionDescriptor<URL> descriptor() {
        return FunctionDescriptor.builder().name(NAME).returnType(URL.class).params(this.urlParam, this.defaultParam).description("Converts a value to a valid URL using its string representation").build();
    }
}

