/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.functions.dates;

import com.google.common.collect.ImmutableList;
import com.joestelmach.natty.DateGroup;
import com.joestelmach.natty.Parser;
import java.util.List;
import java.util.Optional;
import org.graylog.plugins.pipelineprocessor.EvaluationContext;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionArgs;
import org.graylog.plugins.pipelineprocessor.ast.functions.ParameterDescriptor;
import org.graylog.plugins.pipelineprocessor.functions.dates.TimezoneAwareFunction;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class FlexParseDate
extends TimezoneAwareFunction {
    public static final String VALUE = "value";
    public static final String NAME = "flex_parse_date";
    public static final String DEFAULT = "default";
    private final ParameterDescriptor<String, String> valueParam = ParameterDescriptor.string("value").description("Date string to parse").build();
    private final ParameterDescriptor<DateTime, DateTime> defaultParam = ParameterDescriptor.type("default", DateTime.class).optional().description("Used when 'value' could not be parsed, 'null' otherwise").build();

    @Override
    protected DateTime evaluate(FunctionArgs args, EvaluationContext context, DateTimeZone timezone) {
        String time = this.valueParam.required(args, context);
        List dates = new Parser(timezone.toTimeZone()).parse(time);
        if (dates.size() == 0) {
            Optional<DateTime> defaultTime = this.defaultParam.optional(args, context);
            if (defaultTime.isPresent()) {
                return defaultTime.get();
            }
            return null;
        }
        return new DateTime(((DateGroup)dates.get(0)).getDates().get(0), timezone);
    }

    @Override
    protected String description() {
        return "Parses a date string using natural language (see http://natty.joestelmach.com/)";
    }

    @Override
    protected String getName() {
        return NAME;
    }

    @Override
    protected ImmutableList<ParameterDescriptor> params() {
        return ImmutableList.of(this.valueParam, this.defaultParam);
    }
}

