/*
 * Decompiled with CFR 0.152.
 */
package de.hilling.graylog.plugins.multimatch;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.graylog.plugins.pipelineprocessor.ast.functions.Function;
import org.graylog2.plugin.Message;

class MultiMatcher {
    public static final String MESSAGE_KEY = "message";
    private final List<Map<String, String>> matchers;
    private final Message message;

    MultiMatcher(@Nonnull List<Map<String, String>> matchers, @Nonnull Message message) {
        this.matchers = matchers;
        this.message = message;
    }

    boolean invoke() {
        return this.matchers.stream().anyMatch(map -> {
            Function.log.debug("found object {}/{}", map, map.getClass());
            if (map instanceof Map) {
                return map.entrySet().stream().allMatch(this::match);
            }
            Function.log.error("object should be a map, found {}", map.getClass());
            return false;
        });
    }

    private boolean match(Map.Entry<String, String> mapEntry) {
        String key = mapEntry.getKey();
        String value = mapEntry.getValue();
        if (!this.message.hasField(key)) {
            return false;
        }
        if (Objects.equals(key, MESSAGE_KEY)) {
            return this.matchMessage(value);
        }
        return Objects.equals(value, this.message.getField(key));
    }

    private boolean matchMessage(String value) {
        String messageField = (String)this.message.getFieldAs(String.class, MESSAGE_KEY);
        return messageField.matches(value);
    }
}

