/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.functions.messages;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import javax.inject.Provider;
import org.graylog.plugins.pipelineprocessor.EvaluationContext;
import org.graylog.plugins.pipelineprocessor.ast.functions.AbstractFunction;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionArgs;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionDescriptor;
import org.graylog.plugins.pipelineprocessor.ast.functions.ParameterDescriptor;
import org.graylog.plugins.pipelineprocessor.functions.messages.StreamCacheService;
import org.graylog2.plugin.Message;
import org.graylog2.plugin.streams.DefaultStream;
import org.graylog2.plugin.streams.Stream;

public class RemoveFromStream
extends AbstractFunction<Void> {
    public static final String NAME = "remove_from_stream";
    private static final String ID_ARG = "id";
    private static final String NAME_ARG = "name";
    private final StreamCacheService streamCacheService;
    private final Provider<Stream> defaultStreamProvider;
    private final ParameterDescriptor<Message, Message> messageParam;
    private final ParameterDescriptor<String, String> nameParam;
    private final ParameterDescriptor<String, String> idParam;

    @Inject
    public RemoveFromStream(StreamCacheService streamCacheService, @DefaultStream Provider<Stream> defaultStreamProvider) {
        this.streamCacheService = streamCacheService;
        this.defaultStreamProvider = defaultStreamProvider;
        this.messageParam = ParameterDescriptor.type("message", Message.class).optional().description("The message to use, defaults to '$message'").build();
        this.nameParam = ParameterDescriptor.string(NAME_ARG).optional().description("The name of the stream to remove the message from, must match exactly").build();
        this.idParam = ParameterDescriptor.string(ID_ARG).optional().description("The ID of the stream").build();
    }

    @Override
    public Void evaluate(FunctionArgs args, EvaluationContext context) {
        Collection<Object> streams;
        Optional<String> id = this.idParam.optional(args, context);
        if (!id.isPresent()) {
            Optional<Collection> foundStreams = this.nameParam.optional(args, context).map(this.streamCacheService::getByName);
            if (!foundStreams.isPresent()) {
                return null;
            }
            streams = foundStreams.get();
        } else {
            Stream stream2 = this.streamCacheService.getById(id.get());
            if (stream2 == null) {
                return null;
            }
            streams = Collections.singleton(stream2);
        }
        Message message = this.messageParam.optional(args, context).orElse(context.currentMessage());
        streams.forEach(stream -> {
            if (!stream.isPaused().booleanValue()) {
                message.removeStream(stream);
            }
        });
        if (message.getStreams().isEmpty()) {
            message.addStream((Stream)this.defaultStreamProvider.get());
        }
        return null;
    }

    @Override
    public FunctionDescriptor<Void> descriptor() {
        return FunctionDescriptor.builder().name(NAME).returnType(Void.class).params((ImmutableList<ParameterDescriptor>)ImmutableList.of(this.nameParam, this.idParam, this.messageParam)).description("Removes a message from a stream. Removing the last stream will put the message back onto the default stream. To complete drop a message use the drop_message function.").build();
    }
}

