/*
 * Decompiled with CFR 0.152.
 */
package de.be4.eventb.core.parser.node;

import de.be4.eventb.core.parser.node.Node;
import de.hhu.stups.sablecc.patch.IToken;
import de.hhu.stups.sablecc.patch.SourcePosition;

public abstract class Token
extends Node
implements IToken {
    private String text;
    private int line;
    private int pos;

    protected Token(String text, int line, int pos) {
        this.text = text;
        this.line = line;
        this.pos = pos;
    }

    protected Token(String text) {
        this(text, 0, 0);
    }

    @Override
    public abstract Token clone();

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
        this.setStartPos(null);
        this.setEndPos(null);
    }

    public int getLine() {
        return this.line;
    }

    public void setLine(int line) {
        this.line = line;
        this.setStartPos(null);
        this.setEndPos(null);
    }

    public int getPos() {
        return this.pos;
    }

    public void setPos(int pos) {
        this.pos = pos;
        this.setStartPos(null);
        this.setEndPos(null);
    }

    public SourcePosition getStartPos() {
        SourcePosition startPos = super.getStartPos();
        if (startPos == null) {
            startPos = new SourcePosition(this.line, this.pos);
            this.setStartPos(startPos);
        }
        return startPos;
    }

    public SourcePosition getEndPos() {
        SourcePosition endPos = super.getEndPos();
        if (endPos == null) {
            endPos = new SourcePosition(this.line, this.pos + (this.text == null ? 0 : this.text.length()));
            this.setEndPos(endPos);
        }
        return endPos;
    }

    public String toString() {
        return this.text + " ";
    }

    @Override
    void removeChild(Node child) {
        throw new RuntimeException("Not a child.");
    }

    @Override
    void replaceChild(Node oldChild, Node newChild) {
        throw new RuntimeException("Not a child.");
    }
}

