/*
 * Decompiled with CFR 0.152.
 */
package de.be4.eventb.core.parser.lexer;

import de.be4.eventb.core.parser.lexer.LexerException;
import de.be4.eventb.core.parser.node.EOF;
import de.be4.eventb.core.parser.node.TAnticipated;
import de.be4.eventb.core.parser.node.TAny;
import de.be4.eventb.core.parser.node.TAt;
import de.be4.eventb.core.parser.node.TAxioms;
import de.be4.eventb.core.parser.node.TColon;
import de.be4.eventb.core.parser.node.TComma;
import de.be4.eventb.core.parser.node.TComment;
import de.be4.eventb.core.parser.node.TCommentEnd;
import de.be4.eventb.core.parser.node.TCommentStart;
import de.be4.eventb.core.parser.node.TConstants;
import de.be4.eventb.core.parser.node.TContext;
import de.be4.eventb.core.parser.node.TConvergent;
import de.be4.eventb.core.parser.node.TEnd;
import de.be4.eventb.core.parser.node.TEqual;
import de.be4.eventb.core.parser.node.TEvent;
import de.be4.eventb.core.parser.node.TEvents;
import de.be4.eventb.core.parser.node.TExtends;
import de.be4.eventb.core.parser.node.TFormula;
import de.be4.eventb.core.parser.node.TIdentifierLiteral;
import de.be4.eventb.core.parser.node.TInvariants;
import de.be4.eventb.core.parser.node.TLabel;
import de.be4.eventb.core.parser.node.TMachine;
import de.be4.eventb.core.parser.node.TMultiCommentBody;
import de.be4.eventb.core.parser.node.TMultiCommentEnd;
import de.be4.eventb.core.parser.node.TMultiCommentStart;
import de.be4.eventb.core.parser.node.TOrdinary;
import de.be4.eventb.core.parser.node.TRefines;
import de.be4.eventb.core.parser.node.TSees;
import de.be4.eventb.core.parser.node.TSets;
import de.be4.eventb.core.parser.node.TSlash;
import de.be4.eventb.core.parser.node.TStar;
import de.be4.eventb.core.parser.node.TThen;
import de.be4.eventb.core.parser.node.TTheorem;
import de.be4.eventb.core.parser.node.TVariables;
import de.be4.eventb.core.parser.node.TVariant;
import de.be4.eventb.core.parser.node.TWhere;
import de.be4.eventb.core.parser.node.TWhiteSpace;
import de.be4.eventb.core.parser.node.TWith;
import de.be4.eventb.core.parser.node.Token;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackReader;

public class Lexer {
    protected Token token;
    protected State state = State.NORMAL;
    private final PushbackReader in;
    protected int line;
    protected int pos;
    private boolean cr;
    private boolean eof;
    private final StringBuilder text = new StringBuilder();
    private static final int[][][][] gotoTable;
    private static final int[][] accept;

    protected void filter() throws LexerException, IOException {
    }

    public Lexer(PushbackReader in) {
        this.in = in;
    }

    public Token peek() throws LexerException, IOException {
        while (this.token == null) {
            this.token = this.getToken();
            this.filter();
        }
        return this.token;
    }

    public Token next() throws LexerException, IOException {
        while (this.token == null) {
            this.token = this.getToken();
            this.filter();
        }
        Token result = this.token;
        this.token = null;
        return result;
    }

    protected Token getToken() throws IOException, LexerException {
        Token tok;
        int dfaState = 0;
        int startPos = this.pos;
        int startLine = this.line;
        int acceptToken = -1;
        int acceptLength = -1;
        int acceptPos = -1;
        int acceptLine = -1;
        boolean acceptCr = false;
        int[][][] gotoTableSub = gotoTable[this.state.ordinal()];
        int[] acceptSub = accept[this.state.ordinal()];
        this.text.setLength(0);
        while (true) {
            int c;
            if ((c = this.getChar()) != -1) {
                switch (c) {
                    case 10: {
                        if (this.cr) {
                            this.cr = false;
                            break;
                        }
                        ++this.line;
                        this.pos = 0;
                        break;
                    }
                    case 13: {
                        ++this.line;
                        this.pos = 0;
                        this.cr = true;
                        break;
                    }
                    case 8232: 
                    case 8233: {
                        ++this.line;
                        this.pos = 0;
                        this.cr = false;
                        break;
                    }
                    default: {
                        ++this.pos;
                        this.cr = false;
                    }
                }
                this.text.append((char)c);
                block135: do {
                    int oldState = dfaState < -1 ? -2 - dfaState : dfaState;
                    dfaState = -1;
                    int[][] tmp1 = gotoTableSub[oldState];
                    int low = 0;
                    int high = tmp1.length - 1;
                    while (low <= high) {
                        int middle = low + high >>> 1;
                        int[] tmp2 = tmp1[middle];
                        if (c < tmp2[0]) {
                            high = middle - 1;
                            continue;
                        }
                        if (c > tmp2[1]) {
                            low = middle + 1;
                            continue;
                        }
                        dfaState = tmp2[2];
                        continue block135;
                    }
                } while (dfaState < -1);
            } else {
                dfaState = -1;
            }
            if (dfaState < 0) break;
            if (acceptSub[dfaState] == -1) continue;
            acceptToken = acceptSub[dfaState];
            acceptLength = this.text.length();
            acceptPos = this.pos;
            acceptLine = this.line;
            acceptCr = this.cr;
        }
        switch (acceptToken) {
            case -1: {
                if (this.text.length() > 0) {
                    throw new LexerException(startLine + 1, startPos + 1, "Unknown token: " + this.text);
                }
                return new EOF(startLine + 1, startPos + 1);
            }
            case 0: {
                tok = new TCommentStart(this.getText(acceptLength), startLine + 1, startPos + 1);
                switch (this.state.ordinal()) {
                    case 1: {
                        this.state = State.NORMAL;
                        break;
                    }
                    case 0: {
                        this.state = State.COMMENT;
                    }
                }
                break;
            }
            case 1: {
                tok = new TComment(this.getText(acceptLength), startLine + 1, startPos + 1);
                break;
            }
            case 2: {
                tok = new TCommentEnd(this.getText(acceptLength), startLine + 1, startPos + 1);
                switch (this.state.ordinal()) {
                    case 3: {
                        this.state = State.NORMAL;
                    }
                }
                break;
            }
            case 3: {
                tok = new TMultiCommentStart(this.getText(acceptLength), startLine + 1, startPos + 1);
                switch (this.state.ordinal()) {
                    case 1: {
                        this.state = State.MULTI_COMMENT;
                        break;
                    }
                    case 0: {
                        this.state = State.MULTI_COMMENT;
                    }
                }
                break;
            }
            case 4: {
                tok = new TMultiCommentBody(this.getText(acceptLength), startLine + 1, startPos + 1);
                break;
            }
            case 5: {
                tok = new TStar(startLine + 1, startPos + 1);
                break;
            }
            case 6: {
                tok = new TSlash(startLine + 1, startPos + 1);
                break;
            }
            case 7: {
                tok = new TMultiCommentEnd(startLine + 1, startPos + 1);
                break;
            }
            case 8: {
                tok = new TAt(startLine + 1, startPos + 1);
                switch (this.state.ordinal()) {
                    case 1: {
                        this.state = State.NORMAL;
                        break;
                    }
                    case 0: {
                        this.state = State.LABEL;
                    }
                }
                break;
            }
            case 9: {
                tok = new TComma(startLine + 1, startPos + 1);
                break;
            }
            case 10: {
                tok = new TColon(startLine + 1, startPos + 1);
                switch (this.state.ordinal()) {
                    case 0: {
                        this.state = State.FORMULA;
                    }
                }
                break;
            }
            case 11: {
                tok = new TEqual(startLine + 1, startPos + 1);
                break;
            }
            case 12: {
                tok = new TOrdinary(startLine + 1, startPos + 1);
                switch (this.state.ordinal()) {
                    case 1: {
                        this.state = State.NORMAL;
                    }
                }
                break;
            }
            case 13: {
                tok = new TConvergent(startLine + 1, startPos + 1);
                switch (this.state.ordinal()) {
                    case 1: {
                        this.state = State.NORMAL;
                    }
                }
                break;
            }
            case 14: {
                tok = new TAnticipated(startLine + 1, startPos + 1);
                switch (this.state.ordinal()) {
                    case 1: {
                        this.state = State.NORMAL;
                    }
                }
                break;
            }
            case 15: {
                tok = new TMachine(startLine + 1, startPos + 1);
                switch (this.state.ordinal()) {
                    case 1: {
                        this.state = State.NORMAL;
                    }
                }
                break;
            }
            case 16: {
                tok = new TRefines(startLine + 1, startPos + 1);
                switch (this.state.ordinal()) {
                    case 1: {
                        this.state = State.NORMAL;
                    }
                }
                break;
            }
            case 17: {
                tok = new TSees(startLine + 1, startPos + 1);
                switch (this.state.ordinal()) {
                    case 1: {
                        this.state = State.NORMAL;
                    }
                }
                break;
            }
            case 18: {
                tok = new TVariables(startLine + 1, startPos + 1);
                switch (this.state.ordinal()) {
                    case 1: {
                        this.state = State.NORMAL;
                    }
                }
                break;
            }
            case 19: {
                tok = new TInvariants(startLine + 1, startPos + 1);
                switch (this.state.ordinal()) {
                    case 1: {
                        this.state = State.NORMAL;
                    }
                }
                break;
            }
            case 20: {
                tok = new TTheorem(startLine + 1, startPos + 1);
                switch (this.state.ordinal()) {
                    case 1: {
                        this.state = State.NORMAL;
                    }
                }
                break;
            }
            case 21: {
                tok = new TEvents(startLine + 1, startPos + 1);
                switch (this.state.ordinal()) {
                    case 1: {
                        this.state = State.NORMAL;
                    }
                }
                break;
            }
            case 22: {
                tok = new TVariant(startLine + 1, startPos + 1);
                switch (this.state.ordinal()) {
                    case 1: {
                        this.state = State.NORMAL;
                        break;
                    }
                    case 0: {
                        this.state = State.FORMULA;
                    }
                }
                break;
            }
            case 23: {
                tok = new TEnd(startLine + 1, startPos + 1);
                switch (this.state.ordinal()) {
                    case 1: {
                        this.state = State.NORMAL;
                    }
                }
                break;
            }
            case 24: {
                tok = new TContext(startLine + 1, startPos + 1);
                switch (this.state.ordinal()) {
                    case 1: {
                        this.state = State.NORMAL;
                    }
                }
                break;
            }
            case 25: {
                tok = new TExtends(startLine + 1, startPos + 1);
                switch (this.state.ordinal()) {
                    case 1: {
                        this.state = State.NORMAL;
                    }
                }
                break;
            }
            case 26: {
                tok = new TSets(startLine + 1, startPos + 1);
                switch (this.state.ordinal()) {
                    case 1: {
                        this.state = State.NORMAL;
                    }
                }
                break;
            }
            case 27: {
                tok = new TConstants(startLine + 1, startPos + 1);
                switch (this.state.ordinal()) {
                    case 1: {
                        this.state = State.NORMAL;
                    }
                }
                break;
            }
            case 28: {
                tok = new TAxioms(startLine + 1, startPos + 1);
                switch (this.state.ordinal()) {
                    case 1: {
                        this.state = State.NORMAL;
                    }
                }
                break;
            }
            case 29: {
                tok = new TEvent(startLine + 1, startPos + 1);
                switch (this.state.ordinal()) {
                    case 1: {
                        this.state = State.NORMAL;
                    }
                }
                break;
            }
            case 30: {
                tok = new TAny(startLine + 1, startPos + 1);
                switch (this.state.ordinal()) {
                    case 1: {
                        this.state = State.NORMAL;
                    }
                }
                break;
            }
            case 31: {
                tok = new TWhere(this.getText(acceptLength), startLine + 1, startPos + 1);
                switch (this.state.ordinal()) {
                    case 1: {
                        this.state = State.NORMAL;
                    }
                }
                break;
            }
            case 32: {
                tok = new TWith(startLine + 1, startPos + 1);
                switch (this.state.ordinal()) {
                    case 1: {
                        this.state = State.NORMAL;
                    }
                }
                break;
            }
            case 33: {
                tok = new TThen(this.getText(acceptLength), startLine + 1, startPos + 1);
                switch (this.state.ordinal()) {
                    case 1: {
                        this.state = State.NORMAL;
                    }
                }
                break;
            }
            case 34: {
                tok = new TIdentifierLiteral(this.getText(acceptLength), startLine + 1, startPos + 1);
                break;
            }
            case 35: {
                tok = new TLabel(this.getText(acceptLength), startLine + 1, startPos + 1);
                break;
            }
            case 36: {
                tok = new TWhiteSpace(this.getText(acceptLength), startLine + 1, startPos + 1);
                switch (this.state.ordinal()) {
                    case 2: {
                        this.state = State.FORMULA;
                    }
                }
                break;
            }
            case 37: {
                tok = new TFormula(this.getText(acceptLength), startLine + 1, startPos + 1);
                break;
            }
            default: {
                throw new LexerException(startLine + 1, startPos + 1, "Internal lexer error: invalid accept table entry " + acceptToken + ", current text: " + this.text);
            }
        }
        this.pushBack(acceptLength);
        this.pos = acceptPos;
        this.line = acceptLine;
        this.cr = acceptCr;
        return tok;
    }

    private int getChar() throws IOException {
        if (this.eof) {
            return -1;
        }
        int result = this.in.read();
        if (result == -1) {
            this.eof = true;
        }
        return result;
    }

    private void pushBack(int acceptLength) throws IOException {
        int length = this.text.length();
        for (int i = length - 1; i >= acceptLength; --i) {
            this.eof = false;
            this.in.unread(this.text.charAt(i));
        }
    }

    protected void unread(Token tok) throws IOException {
        String tokenText = tok.getText();
        int length = tokenText.length();
        for (int i = length - 1; i >= 0; --i) {
            this.eof = false;
            this.in.unread(tokenText.charAt(i));
        }
        this.pos = tok.getPos() - 1;
        this.line = tok.getLine() - 1;
    }

    private String getText(int acceptLength) {
        return this.text.substring(0, acceptLength);
    }

    static {
        try {
            InputStream resStream = Lexer.class.getResourceAsStream("lexer.dat");
            if (resStream == null) {
                throw new RuntimeException("The file \"lexer.dat\" is missing.");
            }
            DataInputStream s = new DataInputStream(new BufferedInputStream(resStream));
            int gotoTableLength1 = s.readInt();
            gotoTable = new int[gotoTableLength1][][][];
            for (int i = 0; i < gotoTableLength1; ++i) {
                int gotoTableLength2 = s.readInt();
                Lexer.gotoTable[i] = new int[gotoTableLength2][][];
                for (int j = 0; j < gotoTableLength2; ++j) {
                    int gotoTableLength3 = s.readInt();
                    Lexer.gotoTable[i][j] = new int[gotoTableLength3][3];
                    for (int k = 0; k < gotoTableLength3; ++k) {
                        for (int l = 0; l < 3; ++l) {
                            Lexer.gotoTable[i][j][k][l] = s.readInt();
                        }
                    }
                }
            }
            int acceptLength1 = s.readInt();
            accept = new int[acceptLength1][];
            for (int i = 0; i < acceptLength1; ++i) {
                int acceptLength2 = s.readInt();
                Lexer.accept[i] = new int[acceptLength2];
                for (int j = 0; j < acceptLength2; ++j) {
                    Lexer.accept[i][j] = s.readInt();
                }
            }
            s.close();
        }
        catch (IOException e) {
            throw new RuntimeException("The file \"lexer.dat\" is either missing or corrupted.", e);
        }
    }

    public static enum State {
        NORMAL,
        FORMULA,
        LABEL,
        COMMENT,
        MULTI_COMMENT;


        public int id() {
            return this.ordinal();
        }
    }
}

