/*
 * Decompiled with CFR 0.152.
 */
package de.be4.eventb.core.parser;

import de.be4.eventb.core.parser.BException;
import de.be4.eventb.core.parser.EventBLexer;
import de.be4.eventb.core.parser.EventBParseException;
import de.be4.eventb.core.parser.lexer.LexerException;
import de.be4.eventb.core.parser.node.Start;
import de.be4.eventb.core.parser.node.TComment;
import de.be4.eventb.core.parser.node.Token;
import de.be4.eventb.core.parser.parser.Parser;
import de.be4.eventb.core.parser.parser.ParserException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.Files;

public class EventBParser {
    public static final String MSG_COMMENT_PLACEMENT = "Comment can only be place behind the element they belong to. Please move the comment to an appropriate place!";

    public Start parseFile(File machine, boolean verbose) throws IOException, BException {
        try (BufferedReader reader = Files.newBufferedReader(machine.toPath());){
            Start start = this.parse(reader, verbose);
            return start;
        }
    }

    public Start parseFile(File machine) throws IOException, BException {
        return this.parseFile(machine, false);
    }

    public Start parse(String input, boolean debugOutput) throws BException {
        StringReader reader = new StringReader(input);
        return this.parse(reader, debugOutput);
    }

    public Start parse(String input) throws BException {
        return this.parse(input, false);
    }

    public Start parse(Reader reader, boolean debugOutput) throws BException {
        try {
            EventBLexer lexer = new EventBLexer(new PushbackReader(reader, 99));
            lexer.setDebugOutput(debugOutput);
            Parser parser = new Parser(lexer);
            return parser.parse();
        }
        catch (EventBParseException | LexerException e) {
            throw new BException(e);
        }
        catch (ParserException e) {
            throw new BException(this.createEventBParseException(e));
        }
        catch (IOException e) {
            throw new BException(e);
        }
    }

    private EventBParseException createEventBParseException(ParserException e) {
        Token token = e.getToken();
        String message = e.getMessage();
        boolean expectingFound = message.contains("expecting");
        if (expectingFound && token instanceof TComment) {
            message = MSG_COMMENT_PLACEMENT;
        }
        message = message.replaceFirst(" at", " @");
        return new EventBParseException(token, message);
    }
}

