/*
 * Decompiled with CFR 0.152.
 */
package de.be4.eventb.core.parser;

import de.be4.eventb.core.parser.EventBLexerException;
import de.be4.eventb.core.parser.lexer.Lexer;
import de.be4.eventb.core.parser.lexer.LexerException;
import de.be4.eventb.core.parser.node.EOF;
import de.be4.eventb.core.parser.node.TAny;
import de.be4.eventb.core.parser.node.TAxioms;
import de.be4.eventb.core.parser.node.TColon;
import de.be4.eventb.core.parser.node.TComment;
import de.be4.eventb.core.parser.node.TConstants;
import de.be4.eventb.core.parser.node.TContext;
import de.be4.eventb.core.parser.node.TEnd;
import de.be4.eventb.core.parser.node.TEvent;
import de.be4.eventb.core.parser.node.TEvents;
import de.be4.eventb.core.parser.node.TFormula;
import de.be4.eventb.core.parser.node.TInvariants;
import de.be4.eventb.core.parser.node.TMachine;
import de.be4.eventb.core.parser.node.TMultiCommentEnd;
import de.be4.eventb.core.parser.node.TMultiCommentStart;
import de.be4.eventb.core.parser.node.TSets;
import de.be4.eventb.core.parser.node.TThen;
import de.be4.eventb.core.parser.node.TVariables;
import de.be4.eventb.core.parser.node.TVariant;
import de.be4.eventb.core.parser.node.TWhere;
import de.be4.eventb.core.parser.node.TWhiteSpace;
import de.be4.eventb.core.parser.node.TWith;
import de.be4.eventb.core.parser.node.Token;
import java.io.IOException;
import java.io.PushbackReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class EventBLexer
extends Lexer {
    private boolean debugOutput = false;
    private TMultiCommentStart commentStart = null;
    private StringBuilder commentBuffer = null;
    private TFormula string = null;
    private List<Token> stringBuffer;
    private static final String[] clauseErrorMessages = new String[]{"'machine' is only allowed at the beginning of a file", "Variable declarations are only allowed before invariant declarations", "Invariant declarations are only allowed after variables and before the variant", "The variant is only allowed after invariants and before events", "The events clause is only allowed at the end", "'context' is only allowed at the beginning of a file", "Set declarations are only allowed before the constants declarations", "Constants declarations are only allowed after sets and before axioms", "The axioms clause is only allowed at the end"};
    private static final List<Class<? extends Token>> clausesOrder = Collections.unmodifiableList(Arrays.asList(TMachine.class, TVariables.class, TInvariants.class, TVariant.class, TEvents.class, TContext.class, TSets.class, TConstants.class, TAxioms.class));
    private int lastClauseIndex = 0;
    private boolean inEvent = false;
    private static final String[] eventClauseErrorMessages = new String[]{"Parameter declarations (any) are only allowed at the beginning of an event", "Guards (where) are only allowed after parameters and before witnesses", "Witnesses (with) are only allowed after guards and before actions", "Actions (then) are only allowed at the end of an event"};
    private static final List<Class<? extends Token>> eventClausesOrder = Collections.unmodifiableList(Arrays.asList(TAny.class, TWhere.class, TWith.class, TThen.class));
    private int lastEventClauseIndex = 0;

    public EventBLexer(PushbackReader in) {
        super(in);
    }

    @Override
    protected void filter() throws IOException, EventBLexerException {
        this.checkClauseOrders();
        this.collectString();
        this.collectMultiLineComment();
        if (this.token != null && this.debugOutput && !(this.token instanceof TWhiteSpace) && !(this.token instanceof EOF)) {
            System.out.print(this.token.getClass().getSimpleName() + "('" + this.token.getText() + "') ");
        }
    }

    private void checkClauseOrders() throws EventBLexerException {
        if (this.token != null) {
            if (!this.inEvent && this.token instanceof TEvent) {
                this.inEvent = true;
                this.lastEventClauseIndex = 0;
                return;
            }
            if (this.inEvent && this.token instanceof TEnd) {
                this.inEvent = false;
                return;
            }
            if (!this.inEvent && clausesOrder.contains(this.token.getClass())) {
                int nextIndex = clausesOrder.indexOf(this.token.getClass());
                if (nextIndex < this.lastClauseIndex) {
                    this.throwClausesOrderException(clauseErrorMessages[nextIndex]);
                }
                this.lastClauseIndex = nextIndex;
                return;
            }
            if (this.inEvent && eventClausesOrder.contains(this.token.getClass())) {
                int nextIndex = eventClausesOrder.indexOf(this.token.getClass());
                if (nextIndex < this.lastEventClauseIndex) {
                    this.throwClausesOrderException(eventClauseErrorMessages[nextIndex]);
                }
                this.lastEventClauseIndex = nextIndex;
            }
        }
    }

    private void throwClausesOrderException(String message) throws EventBLexerException {
        throw new EventBLexerException(this.token, message, this.token.getText(), this.token.getLine(), this.token.getPos());
    }

    private void collectMultiLineComment() throws EventBLexerException {
        if (this.state.equals((Object)Lexer.State.MULTI_COMMENT)) {
            if (this.token instanceof EOF) {
                throw new EventBLexerException(this.token, "Comment not closed");
            }
            if (this.commentStart == null) {
                this.commentStart = (TMultiCommentStart)this.token;
                this.commentBuffer = new StringBuilder();
                this.token = null;
            } else if (this.token instanceof TMultiCommentEnd) {
                this.token = new TComment(this.commentBuffer.toString(), this.commentStart.getLine(), this.commentStart.getPos());
                this.commentStart = null;
                this.commentBuffer = null;
                this.state = Lexer.State.NORMAL;
            } else {
                this.commentBuffer.append(this.token.getText());
                this.token = null;
            }
        }
    }

    private void collectString() throws EventBLexerException {
        if (!(this.token instanceof EOF) && this.state.equals((Object)Lexer.State.FORMULA)) {
            if (this.string == null) {
                this.beginStringToken();
            } else {
                this.stringBuffer.add(this.token);
                this.token = null;
            }
        } else if (this.string != null) {
            try {
                this.endStringToken();
            }
            catch (LexerException e) {
                EventBLexerException e2 = new EventBLexerException(this.token, e.getMessage());
                e2.initCause(e);
                throw e2;
            }
        }
    }

    private void endStringToken() throws LexerException {
        try {
            this.unread(this.token);
            this.state = Lexer.State.NORMAL;
            this.string.setText(this.createString());
        }
        catch (IOException e) {
            LexerException e2 = new LexerException("IOException occured: " + e.getMessage());
            e2.initCause(e);
            throw e2;
        }
        this.token = this.string;
        this.string = null;
        this.stringBuffer = null;
    }

    private void beginStringToken() throws EventBLexerException {
        if (this.token instanceof TColon || this.token instanceof TWhiteSpace || this.token instanceof TVariant) {
            return;
        }
        if (!(this.token instanceof TFormula)) {
            throw new EventBLexerException(this.token, "Unexpected token '" + this.token.getClass().getSimpleName().substring(1) + "'");
        }
        this.string = (TFormula)this.token;
        this.stringBuffer = new ArrayList<Token>();
        this.stringBuffer.add(this.token);
        this.token = null;
    }

    private String createString() throws IOException {
        int endPos = this.stringBuffer.size() - 1;
        while (this.stringBuffer.get(endPos) instanceof TWhiteSpace) {
            this.unread(this.stringBuffer.get(endPos));
            --endPos;
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i <= endPos; ++i) {
            builder.append(this.stringBuffer.get(i).getText());
        }
        return builder.toString();
    }

    public void setDebugOutput(boolean debugOutput) {
        this.debugOutput = debugOutput;
    }
}

