/* The following code was generated by JFlex 1.4.1 on 2/16/13 11:33 AM */

// Alloy Analyzer 4 -- Copyright (c) 2006-2008, Felix Chang
//
// Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files
// (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify,
// merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
// OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
// LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

package edu.mit.csail.sdg.alloy4compiler.parser;

import edu.mit.csail.sdg.alloy4.Err;
import edu.mit.csail.sdg.alloy4.ErrorSyntax;
import edu.mit.csail.sdg.alloy4.Pos;
import edu.mit.csail.sdg.alloy4.Version;
import edu.mit.csail.sdg.alloy4compiler.ast.ExprConstant;
import edu.mit.csail.sdg.alloy4compiler.ast.ExprVar;
import java.util.List;
import java_cup.runtime.*;

/** Autogenerated by JFlex 1.4.1 */


public final class CompLexer implements java_cup.runtime.Scanner {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int YYINITIAL = 0;

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\11\71\1\73\1\64\1\0\1\73\1\72\16\71\4\0\1\73\1\1"+
    "\1\62\1\2\1\70\1\0\1\3\1\65\1\4\1\5\1\6\1\7"+
    "\1\10\1\11\1\13\1\14\12\66\1\15\1\0\1\16\1\17\1\12"+
    "\1\0\1\20\10\70\1\56\11\70\1\61\7\70\1\21\1\63\1\22"+
    "\1\23\1\70\1\0\1\30\1\31\1\35\1\40\1\41\1\55\1\60"+
    "\1\43\1\45\1\46\1\44\1\36\1\50\1\37\1\47\1\54\1\57"+
    "\1\34\1\32\1\33\1\42\1\53\1\70\1\51\1\52\1\70\1\24"+
    "\1\25\1\26\1\27\41\71\2\0\4\67\4\0\1\67\2\0\1\71"+
    "\7\0\1\67\4\0\1\67\5\0\27\67\1\0\37\67\1\0\u013f\67"+
    "\31\0\162\67\4\0\14\67\16\0\5\67\11\0\1\67\21\0\130\71"+
    "\5\0\23\71\12\0\1\67\13\0\1\67\1\0\3\67\1\0\1\67"+
    "\1\0\24\67\1\0\54\67\1\0\46\67\1\0\5\67\4\0\202\67"+
    "\1\0\4\71\3\0\105\67\1\0\46\67\2\0\2\67\6\0\20\67"+
    "\41\0\46\67\2\0\1\67\7\0\47\67\11\0\21\71\1\0\27\71"+
    "\1\0\3\71\1\0\1\71\1\0\2\71\1\0\1\71\13\0\33\67"+
    "\5\0\3\67\15\0\4\71\14\0\6\71\13\0\32\67\5\0\13\67"+
    "\16\71\7\0\12\71\4\0\2\67\1\71\143\67\1\0\1\67\10\71"+
    "\1\0\6\71\2\67\2\71\1\0\4\71\2\67\12\71\3\67\2\0"+
    "\1\67\17\0\1\71\1\67\1\71\36\67\33\71\2\0\3\67\60\0"+
    "\46\67\13\71\1\67\u014f\0\3\71\66\67\2\0\1\71\1\67\20\71"+
    "\2\0\1\67\4\71\3\0\12\67\2\71\2\0\12\71\21\0\3\71"+
    "\1\0\10\67\2\0\2\67\2\0\26\67\1\0\7\67\1\0\1\67"+
    "\3\0\4\67\2\0\1\71\1\67\7\71\2\0\2\71\2\0\3\71"+
    "\11\0\1\71\4\0\2\67\1\0\3\67\2\71\2\0\12\71\4\67"+
    "\15\0\3\71\1\0\6\67\4\0\2\67\2\0\26\67\1\0\7\67"+
    "\1\0\2\67\1\0\2\67\1\0\2\67\2\0\1\71\1\0\5\71"+
    "\4\0\2\71\2\0\3\71\13\0\4\67\1\0\1\67\7\0\14\71"+
    "\3\67\14\0\3\71\1\0\11\67\1\0\3\67\1\0\26\67\1\0"+
    "\7\67\1\0\2\67\1\0\5\67\2\0\1\71\1\67\10\71\1\0"+
    "\3\71\1\0\3\71\2\0\1\67\17\0\2\67\2\71\2\0\12\71"+
    "\1\0\1\67\17\0\3\71\1\0\10\67\2\0\2\67\2\0\26\67"+
    "\1\0\7\67\1\0\2\67\1\0\5\67\2\0\1\71\1\67\6\71"+
    "\3\0\2\71\2\0\3\71\10\0\2\71\4\0\2\67\1\0\3\67"+
    "\4\0\12\71\1\0\1\67\20\0\1\71\1\67\1\0\6\67\3\0"+
    "\3\67\1\0\4\67\3\0\2\67\1\0\1\67\1\0\2\67\3\0"+
    "\2\67\3\0\3\67\3\0\10\67\1\0\3\67\4\0\5\71\3\0"+
    "\3\71\1\0\4\71\11\0\1\71\17\0\11\71\11\0\1\67\7\0"+
    "\3\71\1\0\10\67\1\0\3\67\1\0\27\67\1\0\12\67\1\0"+
    "\5\67\4\0\7\71\1\0\3\71\1\0\4\71\7\0\2\71\11\0"+
    "\2\67\4\0\12\71\22\0\2\71\1\0\10\67\1\0\3\67\1\0"+
    "\27\67\1\0\12\67\1\0\5\67\2\0\1\71\1\67\7\71\1\0"+
    "\3\71\1\0\4\71\7\0\2\71\7\0\1\67\1\0\2\67\4\0"+
    "\12\71\22\0\2\71\1\0\10\67\1\0\3\67\1\0\27\67\1\0"+
    "\20\67\4\0\6\71\2\0\3\71\1\0\4\71\11\0\1\71\10\0"+
    "\2\67\4\0\12\71\22\0\2\71\1\0\22\67\3\0\30\67\1\0"+
    "\11\67\1\0\1\67\2\0\7\67\3\0\1\71\4\0\6\71\1\0"+
    "\1\71\1\0\10\71\22\0\2\71\15\0\60\67\1\71\2\67\7\71"+
    "\4\0\10\67\10\71\1\0\12\71\47\0\2\67\1\0\1\67\2\0"+
    "\2\67\1\0\1\67\2\0\1\67\6\0\4\67\1\0\7\67\1\0"+
    "\3\67\1\0\1\67\1\0\1\67\2\0\2\67\1\0\4\67\1\71"+
    "\2\67\6\71\1\0\2\71\1\67\2\0\5\67\1\0\1\67\1\0"+
    "\6\71\2\0\12\71\2\0\2\67\42\0\1\67\27\0\2\71\6\0"+
    "\12\71\13\0\1\71\1\0\1\71\1\0\1\71\4\0\2\71\10\67"+
    "\1\0\42\67\6\0\24\71\1\0\2\71\4\67\4\0\10\71\1\0"+
    "\44\71\11\0\1\71\71\0\42\67\1\0\5\67\1\0\2\67\1\0"+
    "\7\71\3\0\4\71\6\0\12\71\6\0\6\67\4\71\106\0\46\67"+
    "\12\0\51\67\7\0\132\67\5\0\104\67\5\0\122\67\6\0\7\67"+
    "\1\0\77\67\1\0\1\67\1\0\4\67\2\0\7\67\1\0\1\67"+
    "\1\0\4\67\2\0\47\67\1\0\1\67\1\0\4\67\2\0\37\67"+
    "\1\0\1\67\1\0\4\67\2\0\7\67\1\0\1\67\1\0\4\67"+
    "\2\0\7\67\1\0\7\67\1\0\27\67\1\0\37\67\1\0\1\67"+
    "\1\0\4\67\2\0\7\67\1\0\47\67\1\0\23\67\16\0\11\71"+
    "\56\0\125\67\14\0\u026c\67\2\0\10\67\12\0\32\67\5\0\113\67"+
    "\3\0\3\67\17\0\15\67\1\0\4\67\3\71\13\0\22\67\3\71"+
    "\13\0\22\67\2\71\14\0\15\67\1\0\3\67\1\0\2\71\14\0"+
    "\64\67\40\71\3\0\1\67\3\0\2\67\1\71\2\0\12\71\41\0"+
    "\3\71\2\0\12\71\6\0\130\67\10\0\51\67\1\71\126\0\35\67"+
    "\3\0\14\71\4\0\14\71\12\0\12\71\36\67\2\0\5\67\u038b\0"+
    "\154\67\224\0\234\67\4\0\132\67\6\0\26\67\2\0\6\67\2\0"+
    "\46\67\2\0\6\67\2\0\10\67\1\0\1\67\1\0\1\67\1\0"+
    "\1\67\1\0\37\67\2\0\65\67\1\0\7\67\1\0\1\67\3\0"+
    "\3\67\1\0\7\67\3\0\4\67\2\0\6\67\4\0\15\67\5\0"+
    "\3\67\1\0\7\67\17\0\4\71\32\0\5\71\20\0\2\67\23\0"+
    "\1\67\13\0\4\71\6\0\6\71\1\0\1\67\15\0\1\67\40\0"+
    "\22\67\36\0\15\71\4\0\1\71\3\0\6\71\27\0\1\67\4\0"+
    "\1\67\2\0\12\67\1\0\1\67\3\0\5\67\6\0\1\67\1\0"+
    "\1\67\1\0\1\67\1\0\4\67\1\0\3\67\1\0\7\67\3\0"+
    "\3\67\5\0\5\67\26\0\44\67\u0e81\0\3\67\31\0\11\67\6\71"+
    "\1\0\5\67\2\0\5\67\4\0\126\67\2\0\2\71\2\0\3\67"+
    "\1\0\137\67\5\0\50\67\4\0\136\67\21\0\30\67\70\0\20\67"+
    "\u0200\0\u19b6\67\112\0\u51a6\67\132\0\u048d\67\u0773\0\u2ba4\67\u215c\0\u012e\67"+
    "\2\0\73\67\225\0\7\67\14\0\5\67\5\0\1\67\1\71\12\67"+
    "\1\0\15\67\1\0\5\67\1\0\1\67\1\0\2\67\1\0\2\67"+
    "\1\0\154\67\41\0\u016b\67\22\0\100\67\2\0\66\67\50\0\15\67"+
    "\3\0\20\71\20\0\4\71\17\0\2\67\30\0\3\67\31\0\1\67"+
    "\6\0\5\67\1\0\207\67\2\0\1\71\4\0\1\67\13\0\12\71"+
    "\7\0\32\67\4\0\1\67\1\0\32\67\12\0\132\67\3\0\6\67"+
    "\2\0\6\67\2\0\6\67\2\0\3\67\3\0\2\67\3\0\2\67"+
    "\22\0\3\71\4\0";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\1\0\1\1\1\2\1\3\1\4\1\5\1\6\1\7"+
    "\1\10\1\11\1\12\1\13\1\14\1\15\1\16\1\17"+
    "\1\20\1\21\1\22\1\23\1\24\1\25\1\26\1\27"+
    "\1\30\23\31\1\32\1\33\1\34\1\35\1\36\1\33"+
    "\1\37\1\40\1\41\1\0\1\42\1\43\1\44\1\45"+
    "\1\46\1\45\1\47\1\31\1\50\14\31\1\51\5\31"+
    "\1\52\3\31\1\47\12\31\1\53\1\0\1\54\1\55"+
    "\2\0\1\56\2\31\1\57\1\35\1\60\1\61\1\62"+
    "\1\63\1\64\2\31\1\65\1\31\1\66\1\31\1\2"+
    "\6\31\1\67\2\31\1\70\2\31\1\56\1\71\6\31"+
    "\1\72\1\73\1\74\1\31\1\75\1\0\1\33\2\31"+
    "\1\76\1\77\1\31\1\100\1\101\1\102\1\103\1\104"+
    "\4\31\1\105\1\106\1\31\1\107\1\31\1\110\1\111"+
    "\1\31\1\112\3\31\1\113\13\31\1\114\4\31\1\115"+
    "\1\31\1\116\2\31\1\117\2\31\1\120\1\121\1\31"+
    "\1\46\1\31\1\122\1\123\1\102\3\31\1\110\1\67";

  private static int [] zzUnpackAction() {
    int [] result = new int[210];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\74\0\74\0\74\0\170\0\74\0\74\0\74"+
    "\0\264\0\74\0\360\0\u012c\0\74\0\u0168\0\u01a4\0\u01e0"+
    "\0\u021c\0\74\0\74\0\74\0\74\0\74\0\u0258\0\74"+
    "\0\74\0\u0294\0\u02d0\0\u030c\0\u0348\0\u0384\0\u03c0\0\u03fc"+
    "\0\u0438\0\u0474\0\u04b0\0\u04ec\0\u0528\0\u0564\0\u05a0\0\u05dc"+
    "\0\u0618\0\u0654\0\u0690\0\u06cc\0\u0708\0\74\0\u0744\0\74"+
    "\0\74\0\u0780\0\74\0\u07bc\0\74\0\u07f8\0\74\0\74"+
    "\0\74\0\u0834\0\74\0\74\0\74\0\u0870\0\u08ac\0\u08e8"+
    "\0\u0924\0\u0960\0\u099c\0\u09d8\0\u0a14\0\u0a50\0\u0a8c\0\u0ac8"+
    "\0\u0b04\0\u0b40\0\u0b7c\0\u0bb8\0\u0bf4\0\u0c30\0\u0c6c\0\u0ca8"+
    "\0\u0ce4\0\u0d20\0\u0d5c\0\u0d98\0\u0dd4\0\u0528\0\u0e10\0\u0e4c"+
    "\0\u0e88\0\u0ec4\0\u0f00\0\u0f3c\0\u0f78\0\u0fb4\0\u0ff0\0\u102c"+
    "\0\u1068\0\u10a4\0\u10e0\0\74\0\u111c\0\u1158\0\74\0\u1194"+
    "\0\u11d0\0\u0528\0\u0528\0\u0528\0\u0528\0\u0528\0\u0528\0\u0528"+
    "\0\u120c\0\u1248\0\u0528\0\u1284\0\u0528\0\u12c0\0\u0528\0\u12fc"+
    "\0\u1338\0\u1374\0\u13b0\0\u13ec\0\u1428\0\u1464\0\u14a0\0\u14dc"+
    "\0\u0528\0\u1518\0\u1554\0\u0528\0\u0528\0\u1590\0\u15cc\0\u1608"+
    "\0\u1644\0\u1680\0\u16bc\0\u0528\0\u0528\0\u0528\0\u16f8\0\u1068"+
    "\0\u1734\0\u111c\0\u1770\0\u17ac\0\u0528\0\u0528\0\u17e8\0\u0528"+
    "\0\u0528\0\u1824\0\u0528\0\u0528\0\u1860\0\u189c\0\u18d8\0\u1914"+
    "\0\u0528\0\u0528\0\u1950\0\u0528\0\u198c\0\u19c8\0\u0528\0\u1a04"+
    "\0\u0528\0\u1a40\0\u1a7c\0\u1ab8\0\u0528\0\u1af4\0\u1b30\0\u1b6c"+
    "\0\u1ba8\0\u1be4\0\u1c20\0\u1c5c\0\u1c98\0\u1cd4\0\u1d10\0\u1d4c"+
    "\0\u0528\0\u1d88\0\u1dc4\0\u1e00\0\u1e3c\0\u0528\0\u1e78\0\u0528"+
    "\0\u1eb4\0\u1ef0\0\u0528\0\u1f2c\0\u1f68\0\u0528\0\u0528\0\u1fa4"+
    "\0\u0528\0\u1fe0\0\u0528\0\u0528\0\u0528\0\u201c\0\u2058\0\u2094"+
    "\0\u0528\0\u0528";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[210];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\2\1\3\1\4\1\5\1\6\1\7\1\10\1\11"+
    "\1\12\1\13\1\14\1\15\1\16\1\17\1\20\1\21"+
    "\1\22\1\23\1\24\1\25\1\26\1\27\1\30\1\31"+
    "\1\32\1\33\1\34\1\35\1\36\1\37\1\40\1\41"+
    "\1\42\1\43\1\44\2\45\1\46\1\45\1\47\1\50"+
    "\3\45\1\51\1\52\1\53\2\45\1\54\1\55\1\2"+
    "\1\56\1\2\1\57\2\45\1\2\2\56\77\0\1\60"+
    "\77\0\1\61\75\0\1\62\1\63\73\0\1\64\4\0"+
    "\1\65\62\0\1\66\5\0\1\62\71\0\1\67\2\0"+
    "\1\15\73\0\1\70\1\71\1\72\66\0\1\73\3\0"+
    "\1\74\102\0\1\75\76\0\1\45\1\76\1\77\3\45"+
    "\1\100\1\101\23\45\2\0\5\45\32\0\12\45\1\102"+
    "\20\45\2\0\5\45\32\0\11\45\1\103\1\104\2\45"+
    "\1\105\1\45\1\106\13\45\2\0\5\45\32\0\13\45"+
    "\1\107\17\45\2\0\5\45\32\0\12\45\1\110\20\45"+
    "\2\0\5\45\32\0\13\45\1\111\17\45\2\0\5\45"+
    "\32\0\11\45\1\112\5\45\1\113\13\45\2\0\5\45"+
    "\32\0\17\45\1\114\13\45\2\0\5\45\32\0\15\45"+
    "\1\115\15\45\2\0\5\45\32\0\6\45\1\116\1\117"+
    "\11\45\1\120\11\45\2\0\5\45\32\0\7\45\1\121"+
    "\23\45\2\0\5\45\32\0\33\45\2\0\5\45\32\0"+
    "\7\45\1\122\1\123\7\45\1\124\4\45\1\125\5\45"+
    "\2\0\5\45\32\0\4\45\1\126\2\45\1\127\14\45"+
    "\1\130\6\45\2\0\5\45\32\0\17\45\1\131\13\45"+
    "\2\0\5\45\32\0\1\132\3\45\1\133\26\45\2\0"+
    "\5\45\32\0\1\134\11\45\1\135\4\45\1\136\13\45"+
    "\2\0\5\45\32\0\7\45\1\137\23\45\2\0\5\45"+
    "\32\0\3\45\1\140\27\45\2\0\5\45\2\0\62\55"+
    "\1\141\1\142\10\55\30\0\33\143\2\0\1\143\1\57"+
    "\1\0\1\143\3\0\64\62\1\56\5\62\1\56\1\62"+
    "\12\0\1\144\61\0\6\145\1\146\65\145\12\0\1\147"+
    "\111\0\2\45\1\150\30\45\2\0\5\45\32\0\2\45"+
    "\1\151\30\45\2\0\5\45\32\0\6\45\1\152\24\45"+
    "\2\0\5\45\32\0\10\45\1\153\22\45\2\0\5\45"+
    "\32\0\3\45\1\154\27\45\2\0\5\45\32\0\3\45"+
    "\1\155\23\45\1\156\3\45\2\0\5\45\32\0\20\45"+
    "\1\157\12\45\2\0\5\45\32\0\30\45\1\160\2\45"+
    "\2\0\5\45\32\0\20\45\1\161\12\45\2\0\5\45"+
    "\32\0\15\45\1\162\15\45\2\0\5\45\32\0\7\45"+
    "\1\163\23\45\2\0\5\45\32\0\11\45\1\164\21\45"+
    "\2\0\5\45\32\0\3\45\1\165\27\45\2\0\5\45"+
    "\32\0\7\45\1\166\23\45\2\0\5\45\32\0\3\45"+
    "\1\167\3\45\1\170\23\45\2\0\5\45\32\0\2\45"+
    "\1\171\30\45\2\0\5\45\32\0\2\45\1\172\30\45"+
    "\2\0\5\45\32\0\12\45\1\173\20\45\2\0\5\45"+
    "\32\0\1\174\2\45\1\175\7\45\1\176\10\45\1\177"+
    "\6\45\2\0\5\45\32\0\15\45\1\200\15\45\2\0"+
    "\5\45\32\0\3\45\1\201\27\45\2\0\5\45\32\0"+
    "\11\45\1\202\21\45\2\0\5\45\32\0\24\45\1\203"+
    "\6\45\2\0\5\45\32\0\25\45\1\204\5\45\2\0"+
    "\5\45\32\0\11\45\1\205\21\45\2\0\5\45\32\0"+
    "\11\45\1\206\21\45\2\0\5\45\32\0\10\45\1\207"+
    "\22\45\2\0\5\45\32\0\4\45\1\210\26\45\2\0"+
    "\5\45\32\0\11\45\1\211\3\45\1\212\15\45\2\0"+
    "\5\45\32\0\5\45\1\213\25\45\2\0\5\45\32\0"+
    "\7\45\1\214\23\45\2\0\5\45\32\0\4\45\1\215"+
    "\26\45\2\0\5\45\32\0\3\45\1\216\27\45\2\0"+
    "\5\45\32\0\4\45\1\217\26\45\2\0\5\45\32\0"+
    "\33\220\2\0\2\220\1\0\1\220\3\0\64\55\1\0"+
    "\7\55\30\0\33\143\2\0\2\143\1\0\1\143\3\0"+
    "\6\145\1\221\73\145\1\221\5\145\1\222\57\145\30\0"+
    "\3\45\1\223\27\45\2\0\5\45\32\0\11\45\1\224"+
    "\21\45\2\0\5\45\32\0\11\45\1\225\21\45\2\0"+
    "\5\45\32\0\2\45\1\226\30\45\2\0\5\45\32\0"+
    "\5\45\1\227\25\45\2\0\5\45\32\0\11\45\1\230"+
    "\21\45\2\0\5\45\32\0\11\45\1\231\21\45\2\0"+
    "\5\45\32\0\16\45\1\232\14\45\2\0\5\45\32\0"+
    "\11\45\1\233\21\45\2\0\5\45\32\0\20\45\1\234"+
    "\12\45\2\0\5\45\32\0\5\45\1\235\25\45\2\0"+
    "\5\45\32\0\11\45\1\236\21\45\2\0\5\45\32\0"+
    "\1\237\32\45\2\0\5\45\32\0\11\45\1\240\21\45"+
    "\2\0\5\45\32\0\23\45\1\241\7\45\2\0\5\45"+
    "\32\0\7\45\1\242\23\45\2\0\5\45\32\0\6\45"+
    "\1\243\24\45\2\0\5\45\32\0\7\45\1\244\23\45"+
    "\2\0\5\45\32\0\12\45\1\245\20\45\2\0\5\45"+
    "\32\0\3\45\1\246\27\45\2\0\5\45\32\0\10\45"+
    "\1\247\22\45\2\0\5\45\32\0\23\45\1\250\7\45"+
    "\2\0\5\45\32\0\3\45\1\251\27\45\2\0\5\45"+
    "\32\0\15\45\1\252\15\45\2\0\5\45\2\0\6\145"+
    "\1\221\5\145\1\56\57\145\30\0\4\45\1\253\26\45"+
    "\2\0\5\45\32\0\4\45\1\254\26\45\2\0\5\45"+
    "\32\0\14\45\1\255\16\45\2\0\5\45\32\0\17\45"+
    "\1\256\13\45\2\0\5\45\32\0\3\45\1\257\27\45"+
    "\2\0\5\45\32\0\7\45\1\260\23\45\2\0\5\45"+
    "\32\0\12\45\1\261\20\45\2\0\5\45\32\0\5\45"+
    "\1\262\25\45\2\0\5\45\32\0\15\45\1\263\15\45"+
    "\2\0\5\45\32\0\6\45\1\264\24\45\2\0\5\45"+
    "\32\0\15\45\1\265\15\45\2\0\5\45\32\0\1\266"+
    "\32\45\2\0\5\45\32\0\7\45\1\267\23\45\2\0"+
    "\5\45\32\0\1\270\32\45\2\0\5\45\32\0\3\45"+
    "\1\271\27\45\2\0\5\45\32\0\15\45\1\272\15\45"+
    "\2\0\5\45\32\0\6\45\1\273\24\45\2\0\5\45"+
    "\32\0\10\45\1\274\22\45\2\0\5\45\32\0\2\45"+
    "\1\275\30\45\2\0\5\45\32\0\3\45\1\276\27\45"+
    "\2\0\5\45\32\0\11\45\1\277\21\45\2\0\5\45"+
    "\32\0\11\45\1\300\21\45\2\0\5\45\32\0\3\45"+
    "\1\301\27\45\2\0\5\45\32\0\3\45\1\302\27\45"+
    "\2\0\5\45\32\0\30\45\1\303\2\45\2\0\5\45"+
    "\32\0\5\45\1\304\25\45\2\0\5\45\32\0\7\45"+
    "\1\305\23\45\2\0\5\45\32\0\22\45\1\306\10\45"+
    "\2\0\5\45\32\0\2\45\1\307\30\45\2\0\5\45"+
    "\32\0\3\45\1\310\27\45\2\0\5\45\32\0\2\45"+
    "\1\311\30\45\2\0\5\45\32\0\15\45\1\312\15\45"+
    "\2\0\5\45\32\0\11\45\1\313\21\45\2\0\5\45"+
    "\32\0\3\45\1\314\27\45\2\0\5\45\32\0\3\45"+
    "\1\315\27\45\2\0\5\45\32\0\15\45\1\316\15\45"+
    "\2\0\5\45\32\0\17\45\1\317\13\45\2\0\5\45"+
    "\32\0\23\45\1\320\7\45\2\0\5\45\32\0\7\45"+
    "\1\321\23\45\2\0\5\45\32\0\11\45\1\322\21\45"+
    "\2\0\5\45\2\0";

  private static int [] zzUnpackTrans() {
    int [] result = new int[8400];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\1\0\3\11\1\1\3\11\1\1\1\11\2\1\1\11"+
    "\4\1\5\11\1\1\2\11\24\1\1\11\1\1\2\11"+
    "\1\1\1\11\1\1\1\11\1\0\3\11\1\1\3\11"+
    "\44\1\1\0\1\1\1\11\2\0\1\11\51\1\1\0"+
    "\101\1";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[210];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the textposition at the last state to be included in yytext */
  private int zzPushbackPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** number of newlines encountered up to the start of the matched text */
  private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the 
   * matched text
   */
  private int yycolumn;

  /** 
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /** denotes if the user-EOF-code has already been executed */
  private boolean zzEOFDone;

  /* user code: */
 public String alloy_filename="";
 public int alloy_lineoffset=0; // If not zero, it is added to the current LINE NUMBER
 public List<Object> alloy_seenDollar;
 public CompModule alloy_module;
 private final Pos alloy_here(String txt) {
    return new Pos(alloy_filename,yycolumn+1,yyline+1+alloy_lineoffset,yycolumn+txt.length(),yyline+1);
 }
 private final Symbol alloy_sym(String txt, int type) {
    Pos p = alloy_here(txt); return new Symbol(type, p, p);
 }
 private final Symbol alloy_string(String txt) throws Err {
    Pos p = alloy_here(txt);
    if (!Version.experimental) throw new ErrorSyntax(p, "String literal is not currently supported.");
    StringBuilder sb = new StringBuilder(txt.length());
    for(int i=0; i<txt.length(); i++) {
       char c = txt.charAt(i);
       if (c=='\r' || c=='\n') throw new ErrorSyntax(p, "String literal cannot span multiple lines; use \\n instead.");
       if (c=='\\') {
          i++;
          if (i>=txt.length()) throw new ErrorSyntax(p, "String literal cannot end with a single \\");
          c = txt.charAt(i);
          if (c=='n') c='\n'; else if (c!='\'' && c!='\"' && c!='\\') throw new ErrorSyntax(p, "String literal currenty only supports\nfour escape sequences: \\\\, \\n, \\\', and \\\"");
       }
       sb.append(c);
    }
    txt = sb.toString();
    if (txt.length()==2) throw new ErrorSyntax(p, "Empty string is not allowed; try rewriting your model to use an empty set instead.");
    return new Symbol(CompSym.STR, p, ExprConstant.Op.STRING.make(p, txt));
 }
 private final Symbol alloy_id(String txt) throws Err {
    Pos p=alloy_here(txt);
    if (alloy_seenDollar.size()==0 && txt.indexOf('$')>=0) alloy_seenDollar.add(null);
    return new Symbol(CompSym.ID, p, ExprVar.make(p,txt));
 }
 private final Symbol alloy_num(String txt) throws Err {
    Pos p=alloy_here(txt);
    int n=0;
    try {
       n=Integer.parseInt(txt);
    } catch(NumberFormatException ex) {
       throw new ErrorSyntax(p, "The number "+txt+" is too large to be stored in a Java integer");
    }
    return new Symbol(CompSym.NUMBER, p, ExprConstant.Op.NUMBER.make(p, n));
 }


  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public CompLexer(java.io.Reader in) {
    this.zzReader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  public CompLexer(java.io.InputStream in) {
    this(new java.io.InputStreamReader(in));
  }

  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 1766) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   * 
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead-zzStartRead);

      /* translate stored positions */
      zzEndRead-= zzStartRead;
      zzCurrentPos-= zzStartRead;
      zzMarkedPos-= zzStartRead;
      zzPushbackPos-= zzStartRead;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzCurrentPos*2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
    }

    /* finally: fill the buffer with new input */
    int numRead = zzReader.read(zzBuffer, zzEndRead,
                                            zzBuffer.length-zzEndRead);

    if (numRead < 0) {
      return true;
    }
    else {
      zzEndRead+= numRead;
      return false;
    }
  }

    
  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Resets the scanner to read from a new input stream.
   * Does not close the old reader.
   *
   * All internal variables are reset, the old input stream 
   * <b>cannot</b> be reused (internal buffer is discarded and lost).
   * Lexical state is set to <tt>ZZ_INITIAL</tt>.
   *
   * @param reader   the new input stream 
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzAtBOL  = true;
    zzAtEOF  = false;
    zzEndRead = zzStartRead = 0;
    zzCurrentPos = zzMarkedPos = zzPushbackPos = 0;
    yyline = yychar = yycolumn = 0;
    zzLexicalState = YYINITIAL;
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Contains user EOF-code, which will be executed exactly once,
   * when the end of file is reached
   */
  private void zzDoEOF() throws java.io.IOException {
    if (!zzEOFDone) {
      zzEOFDone = true;
      yyclose();
    }
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public java_cup.runtime.Symbol next_token() throws java.io.IOException, Err {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      boolean zzR = false;
      for (zzCurrentPosL = zzStartRead; zzCurrentPosL < zzMarkedPosL;
                                                             zzCurrentPosL++) {
        switch (zzBufferL[zzCurrentPosL]) {
        case '\u000B':
        case '\u000C':
        case '\u0085':
        case '\u2028':
        case '\u2029':
          yyline++;
          yycolumn = 0;
          zzR = false;
          break;
        case '\r':
          yyline++;
          yycolumn = 0;
          zzR = true;
          break;
        case '\n':
          if (zzR)
            zzR = false;
          else {
            yyline++;
            yycolumn = 0;
          }
          break;
        default:
          zzR = false;
          yycolumn++;
        }
      }

      if (zzR) {
        // peek one character ahead if it is \n (if we have counted one line too much)
        boolean zzPeek;
        if (zzMarkedPosL < zzEndReadL)
          zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        else if (zzAtEOF)
          zzPeek = false;
        else {
          boolean eof = zzRefill();
          zzEndReadL = zzEndRead;
          zzMarkedPosL = zzMarkedPos;
          zzBufferL = zzBuffer;
          if (eof) 
            zzPeek = false;
          else 
            zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        }
        if (zzPeek) yyline--;
      }
      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;
  
      zzState = zzLexicalState;


      zzForAction: {
        while (true) {
    
          if (zzCurrentPosL < zzEndReadL)
            zzInput = zzBufferL[zzCurrentPosL++];
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = zzBufferL[zzCurrentPosL++];
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          int zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
        case 4: 
          { return alloy_sym(yytext(), CompSym.AMPERSAND   );
          }
        case 84: break;
        case 50: 
          { return alloy_sym(yytext(), CompSym.SEQ         );
          }
        case 85: break;
        case 38: 
          { return alloy_sym(yytext(), CompSym.IMPLIES     );
          }
        case 86: break;
        case 23: 
          { return alloy_sym(yytext(), CompSym.RBRACE      );
          }
        case 87: break;
        case 80: 
          { return alloy_sym(yytext(), CompSym.EXACTLY     );
          }
        case 88: break;
        case 53: 
          { return alloy_sym(yytext(), CompSym.RUN         );
          }
        case 89: break;
        case 36: 
          { return alloy_sym(yytext(), CompSym.SHL         );
          }
        case 90: break;
        case 35: 
          { return alloy_sym(yytext(), CompSym.DOMAIN      );
          }
        case 91: break;
        case 60: 
          { return alloy_sym(yytext(), CompSym.SIGINT      );
          }
        case 92: break;
        case 24: 
          { return alloy_sym(yytext(), CompSym.TILDE       );
          }
        case 93: break;
        case 21: 
          { return alloy_sym(yytext(), CompSym.LBRACE      );
          }
        case 94: break;
        case 7: 
          { return alloy_sym(yytext(), CompSym.STAR        );
          }
        case 95: break;
        case 30: 
          { return alloy_sym(yytext(), CompSym.PLUSPLUS    );
          }
        case 96: break;
        case 58: 
          { return alloy_sym(yytext(), CompSym.FUN         );
          }
        case 97: break;
        case 79: 
          { return alloy_sym(yytext(), CompSym.STRING      );
          }
        case 98: break;
        case 55: 
          { return alloy_sym(yytext(), CompSym.EXH         );
          }
        case 99: break;
        case 56: 
          { return alloy_sym(yytext(), CompSym.INT         );
          }
        case 100: break;
        case 52: 
          { return alloy_sym(yytext(), CompSym.SIG         );
          }
        case 101: break;
        case 73: 
          { return alloy_sym(yytext(), CompSym.PRED        );
          }
        case 102: break;
        case 25: 
          { return alloy_id  (yytext());
          }
        case 103: break;
        case 64: 
          { return alloy_sym(yytext(), CompSym.LONE        );
          }
        case 104: break;
        case 41: 
          { return alloy_sym(yytext(), CompSym.NO          );
          }
        case 105: break;
        case 9: 
          { return alloy_sym(yytext(), CompSym.COMMA       );
          }
        case 106: break;
        case 40: 
          { return alloy_sym(yytext(), CompSym.AS          );
          }
        case 107: break;
        case 63: 
          { return alloy_sym(yytext(), CompSym.THIS        );
          }
        case 108: break;
        case 13: 
          { return alloy_sym(yytext(), CompSym.SLASH       );
          }
        case 109: break;
        case 48: 
          { return alloy_sym(yytext(), CompSym.BUT         );
          }
        case 110: break;
        case 43: 
          { return alloy_string(yytext());
          }
        case 111: break;
        case 66: 
          { return alloy_sym(yytext(), CompSym.DISJ        );
          }
        case 112: break;
        case 32: 
          { return alloy_sym(yytext(), CompSym.SHA         );
          }
        case 113: break;
        case 39: 
          { return alloy_sym(yytext(), CompSym.OR          );
          }
        case 114: break;
        case 45: 
          { return alloy_sym(yytext(), CompSym.SHR         );
          }
        case 115: break;
        case 82: 
          { return alloy_sym(yytext(), CompSym.PRIVATE     );
          }
        case 116: break;
        case 31: 
          { return alloy_sym(yytext(), CompSym.ARROW       );
          }
        case 117: break;
        case 33: 
          { return alloy_sym(yytext(), CompSym.GTE         );
          }
        case 118: break;
        case 20: 
          { return alloy_sym(yytext(), CompSym.CARET       );
          }
        case 119: break;
        case 46: 
          { return alloy_sym(yytext(), CompSym.IFF         );
          }
        case 120: break;
        case 67: 
          { return alloy_sym(yytext(), CompSym.ELSE        );
          }
        case 121: break;
        case 3: 
          { return alloy_sym(yytext(), CompSym.HASH        );
          }
        case 122: break;
        case 12: 
          { return alloy_sym(yytext(), CompSym.DOT         );
          }
        case 123: break;
        case 22: 
          { return alloy_sym(yytext(), CompSym.BAR         );
          }
        case 124: break;
        case 77: 
          { return alloy_sym(yytext(), CompSym.EXPECT      );
          }
        case 125: break;
        case 8: 
          { return alloy_sym(yytext(), CompSym.PLUS        );
          }
        case 126: break;
        case 37: 
          { return alloy_sym(yytext(), CompSym.LTE         );
          }
        case 127: break;
        case 57: 
          { return alloy_sym(yytext(), CompSym.ONE         );
          }
        case 128: break;
        case 71: 
          { return alloy_sym(yytext(), CompSym.OPEN        );
          }
        case 129: break;
        case 11: 
          { return alloy_sym(yytext(), CompSym.GT          );
          }
        case 130: break;
        case 78: 
          { return alloy_sym(yytext(), CompSym.MODULE      );
          }
        case 131: break;
        case 14: 
          { return alloy_sym(yytext(), CompSym.COLON       );
          }
        case 132: break;
        case 51: 
          { return alloy_sym(yytext(), CompSym.SUM         );
          }
        case 133: break;
        case 72: 
          { return alloy_sym(yytext(), CompSym.PART        );
          }
        case 134: break;
        case 16: 
          { return alloy_sym(yytext(), CompSym.EQUALS      );
          }
        case 135: break;
        case 81: 
          { return alloy_sym(yytext(), CompSym.EXTENDS     );
          }
        case 136: break;
        case 1: 
          { throw new ErrorSyntax(alloy_here(" "), "Syntax error at the "+yytext()+" character.");
          }
        case 137: break;
        case 26: 
          { throw new ErrorSyntax(alloy_here(yytext()),"String literal is missing its closing \" character");
          }
        case 138: break;
        case 59: 
          { return alloy_sym(yytext(), CompSym.FOR         );
          }
        case 139: break;
        case 28: 
          { return alloy_num (yytext());
          }
        case 140: break;
        case 70: 
          { return alloy_sym(yytext(), CompSym.IDEN        );
          }
        case 141: break;
        case 15: 
          { return alloy_sym(yytext(), CompSym.LT          );
          }
        case 142: break;
        case 17: 
          { return alloy_sym(yytext(), CompSym.AT          );
          }
        case 143: break;
        case 34: 
          { return alloy_sym(yytext(), CompSym.RANGE       );
          }
        case 144: break;
        case 69: 
          { return alloy_sym(yytext(), CompSym.UNIV        );
          }
        case 145: break;
        case 2: 
          { return alloy_sym(yytext(), CompSym.NOT         );
          }
        case 146: break;
        case 49: 
          { return alloy_sym(yytext(), CompSym.SET         );
          }
        case 147: break;
        case 6: 
          { return alloy_sym(yytext(), CompSym.RPAREN      );
          }
        case 148: break;
        case 42: 
          { return alloy_sym(yytext(), CompSym.IN          );
          }
        case 149: break;
        case 75: 
          { return alloy_sym(yytext(), CompSym.CHECK       );
          }
        case 150: break;
        case 29: 
          { return alloy_sym(yytext(), CompSym.AND         );
          }
        case 151: break;
        case 62: 
          { return alloy_sym(yytext(), CompSym.SOME        );
          }
        case 152: break;
        case 74: 
          { return alloy_sym(yytext(), CompSym.FACT        );
          }
        case 153: break;
        case 10: 
          { return alloy_sym(yytext(), CompSym.MINUS       );
          }
        case 154: break;
        case 5: 
          { return alloy_sym(yytext(), CompSym.LPAREN      );
          }
        case 155: break;
        case 65: 
          { return alloy_sym(yytext(), CompSym.NONE        );
          }
        case 156: break;
        case 18: 
          { return alloy_sym(yytext(), CompSym.LBRACKET    );
          }
        case 157: break;
        case 19: 
          { return alloy_sym(yytext(), CompSym.RBRACKET    );
          }
        case 158: break;
        case 68: 
          { return alloy_sym(yytext(), CompSym.ENUM        );
          }
        case 159: break;
        case 47: 
          { return alloy_sym(yytext(), CompSym.ALL         );
          }
        case 160: break;
        case 83: 
          { return alloy_sym(yytext(), CompSym.ABSTRACT    );
          }
        case 161: break;
        case 76: 
          { return alloy_sym(yytext(), CompSym.ASSERT      );
          }
        case 162: break;
        case 61: 
          { throw new ErrorSyntax(alloy_here(yytext()),"String literal cannot be followed by a legal identifier character.");
          }
        case 163: break;
        case 54: 
          { return alloy_sym(yytext(), CompSym.LET         );
          }
        case 164: break;
        case 27: 
          { 
          }
        case 165: break;
        case 44: 
          { throw new ErrorSyntax(alloy_here(yytext()),"Name cannot start with a number.");
          }
        case 166: break;
        default: 
          if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
            zzAtEOF = true;
            zzDoEOF();
              {   return new Symbol(CompSym.EOF, alloy_here(" "), alloy_here(" "));
 }
          } 
          else {
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
