/*
 * Decompiled with CFR 0.152.
 */
package de.hglabor.utils.kutils;

import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.axay.kspigot.extensions.GeneralExtensionsKt;
import net.axay.kspigot.extensions.bukkit.EntityExtensionsKt;
import net.axay.kspigot.extensions.geometry.ModificationExtensionsKt;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000h\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0004\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a%\u0010\u0006\u001a\u00020\u00072\u0017\u0010\b\u001a\u0013\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\t\u00a2\u0006\u0002\b\nH\u0086\b\u00f8\u0001\u0000\u001a\u0018\u0010\u000b\u001a\u00020\u0007*\u00020\u00032\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u001a\n\u0010\u000f\u001a\u00020\u0007*\u00020\u0010\u001a\n\u0010\u0011\u001a\u00020\u0007*\u00020\u0012\u001a\n\u0010\u0013\u001a\u00020\u0007*\u00020\u0003\u001a\n\u0010\u0014\u001a\u00020\u0007*\u00020\u0010\u001a\n\u0010\u0015\u001a\u00020\u0007*\u00020\u0010\u001a\n\u0010\u0016\u001a\u00020\u0007*\u00020\u0010\u001a\n\u0010\u0017\u001a\u00020\u0018*\u00020\u0019\u001a\n\u0010\u001a\u001a\u00020\u0018*\u00020\u0019\u001a\n\u0010\u001b\u001a\u00020\u0018*\u00020\u0019\u001a\n\u0010\u001c\u001a\u00020\u0018*\u00020\u0019\u001a\u0012\u0010\u001d\u001a\u00020\u0007*\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001f\u001a\n\u0010 \u001a\u00020\u0018*\u00020\u0003\u001a\u0014\u0010!\u001a\u00020\u0007*\u00020\u00032\b\b\u0002\u0010\"\u001a\u00020#\u001a0\u0010$\u001a\u00020\u0007*\u00020\u00032\u0006\u0010%\u001a\u00020&2\b\b\u0002\u0010\"\u001a\u00020#2\b\b\u0002\u0010'\u001a\u00020#2\b\b\u0002\u0010(\u001a\u00020)\u001a\n\u0010*\u001a\u00020\u0007*\u00020\u0010\u001a\n\u0010+\u001a\u00020\u0007*\u00020\u0019\u001a\n\u0010,\u001a\u00020\u0007*\u00020\u0010\"\u001a\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006-"}, d2={"standingBlock", "Lorg/bukkit/block/Block;", "Lorg/jetbrains/annotations/NotNull;", "Lorg/bukkit/entity/Player;", "getStandingBlock", "(Lorg/bukkit/entity/Player;)Lorg/bukkit/block/Block;", "onlinePlayers", "", "block", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "addToInv", "items", "", "Lorg/bukkit/inventory/ItemStack;", "adventure", "Lorg/bukkit/entity/HumanEntity;", "cancel", "Lorg/bukkit/event/Cancellable;", "clearHealFeedSaturate", "clearInv", "closeAndClearInv", "creative", "isAdventure", "", "Lorg/bukkit/entity/Entity;", "isCreative", "isSpectator", "isSurvival", "noMove", "seconds", "", "onGround", "playPlingSound", "pitch", "", "playSound", "sound", "Lorg/bukkit/Sound;", "volume", "location", "Lorg/bukkit/Location;", "spectator", "statueAttributes", "survival", "kutils"})
public final class EntityUtilsKt {
    public static final void statueAttributes(@NotNull Entity $this$statueAttributes) {
        Intrinsics.checkNotNullParameter((Object)$this$statueAttributes, (String)"<this>");
        $this$statueAttributes.setCustomNameVisible(true);
        $this$statueAttributes.setPersistent(false);
        $this$statueAttributes.setInvulnerable(true);
        $this$statueAttributes.setSilent(true);
        $this$statueAttributes.setGravity(false);
        if ($this$statueAttributes instanceof LivingEntity) {
            ((LivingEntity)$this$statueAttributes).setAI(false);
            ((LivingEntity)$this$statueAttributes).setRemoveWhenFarAway(false);
        }
    }

    public static final void onlinePlayers(@NotNull Function1<? super Player, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$onlinePlayers = false;
        Iterable $this$forEach$iv = GeneralExtensionsKt.getOnlinePlayers();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            block.invoke(element$iv);
        }
    }

    public static final void cancel(@NotNull Cancellable $this$cancel) {
        Intrinsics.checkNotNullParameter((Object)$this$cancel, (String)"<this>");
        $this$cancel.setCancelled(true);
    }

    public static final void clearInv(@NotNull HumanEntity $this$clearInv) {
        Intrinsics.checkNotNullParameter((Object)$this$clearInv, (String)"<this>");
        $this$clearInv.getInventory().clear();
    }

    public static final void noMove(@NotNull HumanEntity $this$noMove, int seconds) {
        Intrinsics.checkNotNullParameter((Object)$this$noMove, (String)"<this>");
        $this$noMove.addPotionEffect(new PotionEffect(PotionEffectType.SLOW, seconds * 20, 6, true, false));
        $this$noMove.addPotionEffect(new PotionEffect(PotionEffectType.JUMP, seconds * 20, 250, true, false));
    }

    public static final void closeAndClearInv(@NotNull HumanEntity $this$closeAndClearInv) {
        Intrinsics.checkNotNullParameter((Object)$this$closeAndClearInv, (String)"<this>");
        $this$closeAndClearInv.closeInventory();
        EntityUtilsKt.clearInv($this$closeAndClearInv);
    }

    public static final void clearHealFeedSaturate(@NotNull Player $this$clearHealFeedSaturate) {
        Intrinsics.checkNotNullParameter((Object)$this$clearHealFeedSaturate, (String)"<this>");
        EntityUtilsKt.clearInv((HumanEntity)$this$clearHealFeedSaturate);
        EntityExtensionsKt.feedSaturate((Player)$this$clearHealFeedSaturate);
        $this$clearHealFeedSaturate.setHealth($this$clearHealFeedSaturate.getHealthScale());
    }

    public static final void addToInv(@NotNull Player $this$addToInv, @NotNull List<? extends ItemStack> items) {
        Intrinsics.checkNotNullParameter((Object)$this$addToInv, (String)"<this>");
        Intrinsics.checkNotNullParameter(items, (String)"items");
        Iterable $this$forEach$iv = items;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ItemStack it = (ItemStack)element$iv;
            boolean bl = false;
            ItemStack[] itemStackArray = new ItemStack[]{it};
            $this$addToInv.getInventory().addItem(itemStackArray);
        }
    }

    public static final void playPlingSound(@NotNull Player $this$playPlingSound, @NotNull Number pitch) {
        Intrinsics.checkNotNullParameter((Object)$this$playPlingSound, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)pitch, (String)"pitch");
        $this$playPlingSound.playSound($this$playPlingSound.getLocation(), Sound.BLOCK_NOTE_BLOCK_PLING, 1.0f, pitch.floatValue());
    }

    public static /* synthetic */ void playPlingSound$default(Player player, Number number, int n, Object object) {
        if ((n & 1) != 0) {
            number = 1;
        }
        EntityUtilsKt.playPlingSound(player, number);
    }

    public static final void playSound(@NotNull Player $this$playSound, @NotNull Sound sound, @NotNull Number pitch, @NotNull Number volume, @NotNull Location location) {
        Intrinsics.checkNotNullParameter((Object)$this$playSound, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)sound, (String)"sound");
        Intrinsics.checkNotNullParameter((Object)pitch, (String)"pitch");
        Intrinsics.checkNotNullParameter((Object)volume, (String)"volume");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        $this$playSound.playSound(location, sound, volume.floatValue(), pitch.floatValue());
    }

    public static /* synthetic */ void playSound$default(Player player, Sound sound, Number number, Number number2, Location location, int n, Object object) {
        if ((n & 2) != 0) {
            number = 1;
        }
        if ((n & 4) != 0) {
            number2 = 1;
        }
        if ((n & 8) != 0) {
            Location location2 = player.getLocation();
            Intrinsics.checkNotNullExpressionValue((Object)location2, (String)"fun Player.playSound(sou\u2026Float(), pitch.toFloat())");
            location = location2;
        }
        EntityUtilsKt.playSound(player, sound, number, number2, location);
    }

    public static final void creative(@NotNull HumanEntity $this$creative) {
        Intrinsics.checkNotNullParameter((Object)$this$creative, (String)"<this>");
        $this$creative.setGameMode(GameMode.CREATIVE);
    }

    public static final void survival(@NotNull HumanEntity $this$survival) {
        Intrinsics.checkNotNullParameter((Object)$this$survival, (String)"<this>");
        $this$survival.setGameMode(GameMode.SURVIVAL);
    }

    public static final void adventure(@NotNull HumanEntity $this$adventure) {
        Intrinsics.checkNotNullParameter((Object)$this$adventure, (String)"<this>");
        $this$adventure.setGameMode(GameMode.ADVENTURE);
    }

    public static final void spectator(@NotNull HumanEntity $this$spectator) {
        Intrinsics.checkNotNullParameter((Object)$this$spectator, (String)"<this>");
        $this$spectator.setGameMode(GameMode.SPECTATOR);
    }

    public static final boolean isCreative(@NotNull Entity $this$isCreative) {
        Intrinsics.checkNotNullParameter((Object)$this$isCreative, (String)"<this>");
        return $this$isCreative instanceof Player && ((Player)$this$isCreative).getGameMode() == GameMode.CREATIVE;
    }

    public static final boolean isSurvival(@NotNull Entity $this$isSurvival) {
        Intrinsics.checkNotNullParameter((Object)$this$isSurvival, (String)"<this>");
        return $this$isSurvival instanceof Player && ((Player)$this$isSurvival).getGameMode() == GameMode.SURVIVAL;
    }

    public static final boolean isAdventure(@NotNull Entity $this$isAdventure) {
        Intrinsics.checkNotNullParameter((Object)$this$isAdventure, (String)"<this>");
        return $this$isAdventure instanceof Player && ((Player)$this$isAdventure).getGameMode() == GameMode.ADVENTURE;
    }

    public static final boolean isSpectator(@NotNull Entity $this$isSpectator) {
        Intrinsics.checkNotNullParameter((Object)$this$isSpectator, (String)"<this>");
        return $this$isSpectator instanceof Player && ((Player)$this$isSpectator).getGameMode() == GameMode.SPECTATOR;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean onGround(@NotNull Player $this$onGround) {
        Intrinsics.checkNotNullParameter((Object)$this$onGround, (String)"<this>");
        if ($this$onGround.isFlying()) return false;
        Location location = $this$onGround.getLocation().clone();
        Intrinsics.checkNotNullExpressionValue((Object)location, (String)"location.clone()");
        if (ModificationExtensionsKt.subtract((Location)location, (Number)0, (Number)0.1, (Number)0).getBlock().getType() == Material.AIR) return false;
        if ($this$onGround.getVelocity().getY() != 0.0) return false;
        return true;
    }

    @NotNull
    public static final Block getStandingBlock(@NotNull Player $this$standingBlock) {
        Intrinsics.checkNotNullParameter((Object)$this$standingBlock, (String)"<this>");
        Block block = $this$standingBlock.getLocation().getBlock().getRelative(BlockFace.DOWN);
        Intrinsics.checkNotNullExpressionValue((Object)block, (String)"<get-standingBlock>");
        return block;
    }
}

