/*
 * Decompiled with CFR 0.152.
 */
package de.hglabor.soupcore.recraft;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.bukkit.Material;

public class RecraftMaterial
extends HashMap<Material, Integer> {
    private final int maxSoupAmount;

    public RecraftMaterial(int getMaxSoupAmount, Material ... materials) {
        this.maxSoupAmount = getMaxSoupAmount;
        Arrays.stream(materials).forEach((? super T material) -> this.put(material, 0));
    }

    public float getPoints() {
        return this.getOrDefault(this.getLowestMaterial(), 0).intValue();
    }

    public void decrease(Material material, int amount) {
        this.put(material, (Integer)this.get(material) - amount);
    }

    public Material getLowestMaterial() {
        if (this.size() > 1) {
            if (this.values().stream().anyMatch(integer -> integer == 0)) {
                return null;
            }
            Optional<Map.Entry> materialIntegerEntry = this.entrySet().stream().min(Comparator.comparingInt(Map.Entry::getValue));
            return materialIntegerEntry.map(Map.Entry::getKey).orElse(null);
        }
        return this.keySet().stream().findFirst().orElse(null);
    }

    public float getMaterialValue() {
        return (float)this.maxSoupAmount / (float)this.size();
    }

    public void reset() {
        this.replaceAll((m, v) -> 0);
    }
}

