/*
 * Decompiled with CFR 0.152.
 */
package de.hglabor.soupcore.recraft;

import de.hglabor.soupcore.recraft.RecraftMaterial;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class Recraft {
    private final List<RecraftMaterial> recraftMaterials = List.of(new RecraftMaterial(1, Material.RED_MUSHROOM, Material.BROWN_MUSHROOM), new RecraftMaterial(1, Material.COCOA_BEANS), new RecraftMaterial(1, Material.CACTUS));

    public void calcRecraft(ItemStack[] items) {
        this.recraftMaterials.forEach(RecraftMaterial::reset);
        for (ItemStack item : items) {
            if (item == null) continue;
            for (RecraftMaterial recraftMaterial : this.recraftMaterials) {
                Material type;
                if (!recraftMaterial.containsKey(type = item.getType())) continue;
                recraftMaterial.put(type, recraftMaterial.getOrDefault(type, 0) + item.getAmount());
            }
        }
    }

    public void decrease(Player player, int amount) {
        ArrayList<Material> lowestMaterials = new ArrayList<Material>();
        for (RecraftMaterial recraftMaterial : this.recraftMaterials) {
            if (recraftMaterial.getLowestMaterial() == null) continue;
            lowestMaterials.add(recraftMaterial.getLowestMaterial());
        }
        Material highestMaterial = null;
        float i = 0.0f;
        for (Material lowestMaterial : lowestMaterials) {
            RecraftMaterial recraftMaterial = this.byMaterial(lowestMaterial);
            if (!((float)((Integer)recraftMaterial.get(lowestMaterial)).intValue() * recraftMaterial.getMaterialValue() > i)) continue;
            i = (float)((Integer)recraftMaterial.get(lowestMaterial)).intValue() * recraftMaterial.getMaterialValue();
            highestMaterial = lowestMaterial;
        }
        RecraftMaterial recraftMaterial = this.byMaterial(highestMaterial);
        recraftMaterial.decrease(highestMaterial, amount);
        for (ItemStack item : player.getInventory().getContents()) {
            if (item == null || !item.getType().equals(highestMaterial)) continue;
            item.setAmount(item.getAmount() - amount);
            break;
        }
    }

    public RecraftMaterial byMaterial(Material material) {
        return this.recraftMaterials.stream().filter(recraftMaterial -> recraftMaterial.containsKey(material)).findFirst().orElse(null);
    }

    public float getRecraftPoints() {
        float points = 0.0f;
        for (RecraftMaterial recraftMaterial : this.recraftMaterials) {
            points += recraftMaterial.getPoints();
        }
        return points;
    }
}

