package de.hglabor.notify.mixins.server;

import de.hglabor.notify.events.server.player.*;
import me.obsilabor.alert.EventManager;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_3222;
import net.minecraft.class_8791;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Environment(EnvType.SERVER)
@Mixin(value = class_3222.class)
public abstract class MixinServerPlayerEntity {
    @Inject(method = "tick", at = @At("TAIL"))
    public void tick(CallbackInfo ci) {
        EventManager.callEvent(new PlayerTickEvent((class_3222) (Object) this));
    }

    @Inject(method = "dropSelectedItem", at = @At("HEAD"), cancellable = true)
    public void dropSelectedItem(boolean dropAll, CallbackInfoReturnable<Boolean> cir) {
        var player = ((class_3222) (Object) this);
        var evt = EventManager.callEvent(new PlayerItemDropEvent(player, player.method_6047()));
        if (evt.isCancelled()) {
            // Sync client inventory
            player.field_7512.method_34252();
            cir.setReturnValue(false);
        }
    }

    /**
     * Called when item was already dropped; call PlayerItem<em>Dropped</em>Event
     */
    @Inject(method = "dropItem", at = @At("TAIL"), locals = LocalCapture.CAPTURE_FAILHARD)
    public void injectDropItem(class_1799 stack, boolean throwRandomly, boolean retainOwnership, CallbackInfoReturnable<class_1542> cir, class_1542 itemEntity) {
        var player = ((class_3222) (Object) this);
        EventManager.callEvent(new PlayerItemDroppedEvent(player, itemEntity));
    }

    @Inject(method = "onDeath", at = @At("HEAD"), cancellable = true)
    public void onDeath(CallbackInfo ci) {
        var player = ((class_3222) (Object) this);
        var evt = EventManager.callEvent(new PlayerDeathEvent(player));
        if (evt.isCancelled()) {
            ci.cancel();
        }
    }

    @Inject(method = "setClientOptions", at = @At("HEAD"))
    public void setClientOptions(class_8791 clientOptions, CallbackInfo ci) {
        var player = ((class_3222) (Object) this);
        EventManager.callEvent(new PlayerSetClientOptionEvent(player, clientOptions));
    }
}
