package de.hglabor.notify.mixins.server;

import de.hglabor.notify.events.server.player.PlayerInteractBlockEvent;
import de.hglabor.notify.events.server.player.PlayerQuitEvent;
import de.hglabor.notify.events.server.player.PlayerSwapHandItemsEvent;
import me.obsilabor.alert.EventManager;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2846;
import net.minecraft.class_2885;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_3324;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Environment(EnvType.SERVER)
@Mixin(class_3244.class)
public class MixinServerPlayNetworkHandler {
    @Shadow public class_3222 player;

    @Inject(method = "onPlayerAction", at = @At(value = "INVOKE", target="Lnet/minecraft/server/network/ServerPlayerEntity;setStackInHand(Lnet/minecraft/util/Hand;Lnet/minecraft/item/ItemStack;)V"), cancellable = true)
    public void onPlayerAction(class_2846 playerActionC2SPacket, CallbackInfo ci) {
        var evt = EventManager.callEvent(new PlayerSwapHandItemsEvent(player));
        if (evt.isCancelled()) {
            // Sync client inventory
            player.field_7512.method_34252();

            ci.cancel();
        }
    }

    @Redirect(
        method = "cleanUp",
        at = @At(
            value = "INVOKE",
            target = "Lnet/minecraft/server/PlayerManager;broadcast(Lnet/minecraft/text/Text;Z)V"
        )
    )
    private void onPlayerDisconnect(class_3324 instance, class_2561 message, boolean overlay) {
        var evt = EventManager.callEvent(new PlayerQuitEvent(player, message));
        if (evt.getQuitMessage() != null) instance.method_43514(evt.getQuitMessage(), overlay);
    }

    @Inject(method = "onPlayerInteractBlock", at = @At("HEAD"), cancellable = true)
    public void onPlayerInteractBlock(class_2885 packet, CallbackInfo ci) {
        var evt = EventManager.callEvent(new PlayerInteractBlockEvent(player, packet.method_12546(), packet.method_12543()));
        if (evt.isCancelled()) {
            // Sync client inventory
            player.field_7512.method_34252();
            ci.cancel();
        }
    }
}
