package de.hglabor.notify.mixins.server;

import de.hglabor.notify.events.server.entity.EntitySpawnEvent;
import me.obsilabor.alert.EventManager;
import net.minecraft.class_1297;
import net.minecraft.class_5568;
import net.minecraft.class_5579;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_5579.class)
public class MixinServerEntityManager<T extends class_5568> {
    @Inject(method = "addEntity(Lnet/minecraft/world/entity/EntityLike;Z)Z", at = @At("HEAD"), cancellable = true)
    public void addEntity(T entityLike, boolean existing, CallbackInfoReturnable<Boolean> cir) {
        if (entityLike instanceof class_1297 entity) {
            var evt = EventManager.callEvent(new EntitySpawnEvent(entity, existing));
            if (evt.isCancelled()) {
                cir.setReturnValue(false);
            }
        }
    }
}
