package de.hglabor.notify.mixins;

import de.hglabor.notify.events.player.PlayerSlotClickEvent;
import de.hglabor.notify.events.server.player.PlayerCraftItemEvent;
import me.obsilabor.alert.EventManager;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_1703.class)
public class MixinScreenHandler {
    @Inject(method = "onSlotClick", at = @At("HEAD"), cancellable = true)
    public void onSlotClick(int slotId, int j, class_1713 slotActionType, class_1657 playerEntity, CallbackInfo ci) {
        class_1799 stack = null;
        try {
             stack = playerEntity.field_7512.method_7611(slotId).method_7677();
        }
        catch (Exception ignored) {}
        // click event
        var evt = EventManager.callEvent(new PlayerSlotClickEvent(playerEntity, stack, slotId, slotActionType));
        if (evt.isCancelled()) {
            playerEntity.field_7512.method_34252();
            ci.cancel();
        }
        else if (stack != null && stack.method_7909() != class_1802.field_8162 && slotId == 0) {
            // craft event
            var craftEvent = EventManager.callEvent(new PlayerCraftItemEvent(playerEntity, stack, slotActionType));
            if (craftEvent.isCancelled()) {
                playerEntity.field_7512.method_34252();
                ci.cancel();
            }
        }
    }
}
