package de.hglabor.notify.mixins;

import de.hglabor.notify.events.player.PlayerAttackEntityEvent;
import de.hglabor.notify.events.player.PlayerNoClipEvent;
import de.hglabor.notify.events.player.PlayerGetActiveEyeHeightEvent;
import de.hglabor.notify.events.player.PlayerGetEntityDimensionsEvent;
import me.obsilabor.alert.EventManager;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import org.objectweb.asm.Opcodes;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;


@Mixin(class_1657.class)
public abstract class MixinPlayerEntity {
    @Inject(method = "attack", at = @At("HEAD"), cancellable = true)
    public void attack(class_1297 entity, CallbackInfo ci) {
        var evt = EventManager.callEvent(new PlayerAttackEntityEvent((class_1657) (Object) this, entity));
        if (evt.isCancelled()) ci.cancel();
    }

    @Redirect(method = "tick", at = @At(value = "FIELD", target = "Lnet/minecraft/entity/player/PlayerEntity;noClip:Z", opcode = Opcodes.PUTFIELD))
    private void noClipInjection(class_1657 instance, boolean value) {
        var event = EventManager.callEvent(new PlayerNoClipEvent(instance,value));
        instance.field_5960 = event.getNoClip();
    }

    @Inject(method = "getDimensions", at = @At("RETURN"), cancellable = true)
    private void getDimensionsInjection(class_4050 entityPose, CallbackInfoReturnable<class_4048> cir) {
        var event = EventManager.callEvent(new PlayerGetEntityDimensionsEvent((class_1657) ((Object) this), cir.getReturnValue()));
        cir.setReturnValue(event.getDimensions());
    }

    @Inject(method = "getActiveEyeHeight", at = @At("RETURN"), cancellable = true)
    private void getActiveEyeHeightInjection(class_4050 entityPose, class_4048 entityDimensions, CallbackInfoReturnable<Float> cir) {
        var event = EventManager.callEvent(new PlayerGetActiveEyeHeightEvent((class_1657) ((Object) this), entityDimensions, entityPose, cir.getReturnValue()));
        cir.setReturnValue(event.getEyeHeight());
    }
}
