package de.hglabor.notify.mixins;

import de.hglabor.notify.events.entity.EntityInitDataTrackerEvent;
import de.hglabor.notify.events.entity.EntityOnTrackedDataSetEvent;
import me.obsilabor.alert.EventManager;
import net.minecraft.class_1297;
import net.minecraft.class_2940;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_1297.class)
public abstract class MixinEntity {
    @Shadow
    protected abstract void initDataTracker();

    @Redirect(method = "<init>", at = @At(value = "INVOKE", target = "Lnet/minecraft/entity/Entity;initDataTracker()V"))
    private void initInjection(class_1297 instance) {
        var event = EventManager.callEvent(new EntityInitDataTrackerEvent(instance));
        if (!event.isCancelled()) {
            initDataTracker();
        }
    }

    @Inject(method = "onTrackedDataSet", at = @At("TAIL"))
    private void onTrackedDataSetInjection(class_2940<?> data, CallbackInfo ci) {
        EventManager.callEvent(new EntityOnTrackedDataSetEvent((class_1297) (Object) this, data));
    }
}
