package de.hglabor.notify.mixins.server;

import de.hglabor.notify.events.server.player.PlayerBreakBlockEvent;
import de.hglabor.notify.events.server.player.PlayerInteractItemEvent;
import me.obsilabor.alert.EventManager;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_3222;
import net.minecraft.class_3225;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Environment(EnvType.SERVER)
@Mixin(value = class_3225.class)
public class MixinServerPlayerInteractionManager {
    @Shadow @Final protected class_3222 player;

    @Inject(method = "interactItem", at = @At("HEAD"), cancellable = true)
    public void interactItem(class_3222 player, class_1937 world, class_1799 stack, class_1268 hand, CallbackInfoReturnable<class_1269> cir) {
        var evt = EventManager.callEvent(new PlayerInteractItemEvent(player, stack, hand));

        if (evt.isCancelled()) {
            cir.setReturnValue(class_1269.field_21466);
        }
    }

    @Inject(method = "tryBreakBlock", at = @At("HEAD"), cancellable = true)
    public void tryBreakBlock(class_2338 pos, CallbackInfoReturnable<Boolean> cir) {
        var evt = EventManager.callEvent(new PlayerBreakBlockEvent(player, pos));
        if (evt.isCancelled()) cir.setReturnValue(false);
    }
}
