package de.hglabor.notify.mixins;

import de.hglabor.notify.events.player.PlayerSlotClickEvent;
import me.obsilabor.alert.EventManager;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_1703.class)
public class MixinScreenHandler {
    @Inject(method = "onSlotClick", at = @At("HEAD"), cancellable = true)
    public void onSlotClick(int slotId, int j, class_1713 slotActionType, class_1657 playerEntity, CallbackInfo ci) {
        var evt = EventManager.callEvent(new PlayerSlotClickEvent(playerEntity, slotId, slotActionType));
        if (evt.isCancelled()) {
            playerEntity.field_7512.method_34252();
            ci.cancel();
        }
    }
}
