package de.hglabor.notify.mixins;

import de.hglabor.notify.events.entity.EntityDamageEvent;
import me.obsilabor.alert.EventManager;
import net.minecraft.class_1282;
import net.minecraft.class_1309;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_1309.class)
public class MixinLivingEntity {

    @Inject(method = "damage", at = @At("HEAD"), cancellable = true)
    private void onHurt(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        final var event = EventManager.callEvent(new EntityDamageEvent((class_1309) (Object) this, source, amount));
        if (event.isCancelled()) cir.setReturnValue(false);
    }
}