package de.hglabor.notify.mixins;

import de.hglabor.notify.events.player.PlayerPlaceBlockEvent;
import me.obsilabor.alert.EventManager;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_1747.class)
public class MixinBlockItem {

    @Inject(method = "place(Lnet/minecraft/item/ItemPlacementContext;)Lnet/minecraft/util/ActionResult;", at = @At("HEAD"), cancellable = true)
    public void place(class_1750 context, CallbackInfoReturnable<class_1269> cir) {
        var player = context.method_8036();
        if (player != null) {
            var evt = EventManager.callEvent(new PlayerPlaceBlockEvent(player, context));
            if (evt.isCancelled()) {
                // Sync client inventory
                player.field_7512.method_34252();
                cir.setReturnValue(class_1269.field_5814);
            }
        }
    }
}
