package de.hglabor.notify.mixins.server;

import de.hglabor.notify.events.server.player.PlayerSwapHandItemsEvent;
import me.obsilabor.alert.EventManager;
import net.minecraft.class_2846;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_3244.class)
public class MixinServerPlayNetworkHandler {
    @Shadow public class_3222 player;

    @Inject(method = "onPlayerAction", at = @At(value = "INVOKE", target="Lnet/minecraft/server/network/ServerPlayerEntity;setStackInHand(Lnet/minecraft/util/Hand;Lnet/minecraft/item/ItemStack;)V"), cancellable = true)
    public void onPlayerAction(class_2846 playerActionC2SPacket, CallbackInfo ci) {
        var evt = new PlayerSwapHandItemsEvent(player);
        EventManager.callEvent(evt);
        if (evt.isCancelled()) {
            // Sync client inventory
            player.field_7512.method_34252();

            ci.cancel();
        }
    }
}
