package de.hglabor.notify.mixins.server;

import de.hglabor.notify.events.server.player.PlayerJoinEvent;
import de.hglabor.notify.events.server.player.PlayerLeaveEvent;
import me.obsilabor.alert.EventManager;
import net.minecraft.class_2535;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value = class_3324.class)
public class MixinPlayerManager {
    @Inject(method = "onPlayerConnect", at = @At("TAIL"))
    public void onPlayerConnect(class_2535 clientConnection, class_3222 player, CallbackInfo ci) {
        EventManager.callEvent(new PlayerJoinEvent(player));
    }

    @Inject(method = "remove", at = @At("TAIL"))
    public void remove(class_3222 player, CallbackInfo ci) {
        EventManager.callEvent(new PlayerLeaveEvent(player));
    }
}
