/*
 * Decompiled with CFR 0.152.
 */
package de.hglabor.utils.localization;

import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.text.StringSubstitutor;

public final class Localization {
    public static final Localization INSTANCE = new Localization();
    private final Map<Locale, Map<String, String>> translations = new HashMap<Locale, Map<String, String>>();
    private final Gson gson = new Gson();
    private String colorReplaceValue;

    private Localization() {
    }

    public void loadLanguageFiles(Path folder, String colorReplaceValue) {
        try {
            this.colorReplaceValue = colorReplaceValue;
            File[] files = folder.toFile().listFiles();
            if (files == null) {
                throw new Exception("Folder files are null");
            }
            for (File languageFile : files) {
                String name = languageFile.getName();
                System.out.printf("Parsing file %s\n", name);
                if (!name.contains("_")) continue;
                name = name.substring(name.indexOf("_") + 1, name.lastIndexOf(".json"));
                JsonReader reader = new JsonReader((Reader)new FileReader(languageFile));
                Map json = (Map)this.gson.fromJson(reader, Map.class);
                if (json == null) continue;
                Locale key = Locale.forLanguageTag(name);
                if (this.translations.containsKey(key)) {
                    this.translations.get(key).putAll(json);
                    continue;
                }
                this.translations.put(key, json);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getMessage(String key, Locale locale) {
        if (this.translations.containsKey(locale)) {
            return this.translations.get(locale).getOrDefault(key, key).replaceAll("&", this.colorReplaceValue);
        }
        return this.translations.get(Locale.ENGLISH).getOrDefault(key, key).replaceAll("&", this.colorReplaceValue);
    }

    public String getMessage(String key, Map<String, String> values, Locale locale) {
        return StringSubstitutor.replace((Object)this.getMessage(key, locale), values).replaceAll("&", this.colorReplaceValue);
    }
}

