/*
 * Decompiled with CFR 0.152.
 */
package de.hglabor.knockbackapi.config;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.yaml.YamlConfigurationLoader;

public class KnockbackAPIConfiguration {
    public static final KnockbackAPIConfiguration INSTANCE = new KnockbackAPIConfiguration();
    private final Path path = Path.of("config", "knockback-api.yaml");
    private final ConfigurationNode root;

    public KnockbackAPIConfiguration() {
        try {
            if (!Files.exists(this.path, new LinkOption[0])) {
                Files.createFile(this.path, new FileAttribute[0]);
            }
            YamlConfigurationLoader loader = ((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().path(this.path)).build();
            this.root = loader.load();
            ConfigurationNode masterNode = this.root.node(new Object[]{"master-plugin"});
            String masterPlugin = masterNode.getString();
            if (masterPlugin == null) {
                masterNode.set((Object)"just-another-plugin");
                loader.save(this.root);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getMasterPlugin() {
        return this.root.node(new Object[]{"master-plugin"}).getString();
    }
}

