/*
 * Decompiled with CFR 0.152.
 */
package de.hglabor.plugins.kitapi.util;

import de.hglabor.plugins.kitapi.kit.AbstractKit;
import de.hglabor.plugins.kitapi.kit.config.KitMetaData;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.block.Block;
import org.jetbrains.annotations.Nullable;

public final class Utils {
    private Utils() {
    }

    public static boolean isUnbreakableLaborBlock(Block b) {
        return b.hasMetadata(KitMetaData.GLADIATOR_BLOCK.getKey()) || b.hasMetadata(KitMetaData.FEAST_BLOCK.getKey()) || b.hasMetadata(KitMetaData.UNBREAKABLE_BLOCK.getKey()) || b.getType() == Material.BEDROCK;
    }

    public static List<Field> getAllFields(AbstractKit kit) {
        ArrayList<Field> fields = new ArrayList<Field>();
        Collections.addAll(fields, kit.getClass().getDeclaredFields());
        Collections.addAll(fields, kit.getClass().getSuperclass().getDeclaredFields());
        return fields;
    }

    public static int translateGuiScale(int toTranslate) {
        if (toTranslate < 10) {
            return 9;
        }
        if (toTranslate > 10 && toTranslate <= 18) {
            return 18;
        }
        if (toTranslate > 18 && toTranslate <= 27) {
            return 27;
        }
        if (toTranslate > 27 && toTranslate <= 36) {
            return 36;
        }
        if (toTranslate > 36 && toTranslate <= 45) {
            return 45;
        }
        if (toTranslate > 45) {
            return 54;
        }
        return 9;
    }

    public static <I> List<I> cloneList(List<I> list) {
        return new ArrayList<I>(list);
    }

    public static <T> void drawCircle(double radius, Location center, Particle particle, @Nullable T particleData) {
        for (double i = 0.0; i < 0.5; i += 1.0) {
            for (double y = 0.0; y < Math.PI * 2; y += 0.1) {
                double x = radius * Math.cos(y);
                double z = radius * Math.sin(y);
                center.getWorld().spawnParticle(particle, center.clone().add(x, i / 4.0, z), 0, 0.0, 0.0, 0.0, 5.0, particleData);
            }
        }
    }
}

