/*
 * Decompiled with CFR 0.152.
 */
package de.hglabor.plugins.kitapi.kit.selector;

import de.hglabor.plugins.kitapi.KitApi;
import de.hglabor.plugins.kitapi.kit.AbstractKit;
import de.hglabor.utils.noriskutils.ChatUtils;
import de.hglabor.utils.noriskutils.ItemBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public abstract class PassiveSelector
implements Listener {
    protected final int MAX_AMOUNT_OF_PASSIVES;
    protected final String PASSIVE_SELECTOR_TITLE;
    protected final ItemStack LAST_PAGE_ITEM;
    protected final ItemStack NEXT_PAGE_ITEM;
    protected ItemStack passiveSelectorItem;
    protected Map<Locale, List<Inventory>> passivePages;

    public PassiveSelector(String passiveSelectorTitle) {
        this.PASSIVE_SELECTOR_TITLE = passiveSelectorTitle;
        this.MAX_AMOUNT_OF_PASSIVES = 35;
        this.LAST_PAGE_ITEM = new ItemBuilder(Material.RED_STAINED_GLASS_PANE).setName(ChatColor.RED + "<-").build();
        this.NEXT_PAGE_ITEM = new ItemBuilder(Material.GREEN_STAINED_GLASS_PANE).setName(ChatColor.GREEN + "->").build();
        this.passivePages = new HashMap<Locale, List<Inventory>>();
    }

    protected abstract void onKitSelectorClick(PlayerInteractEvent var1);

    protected abstract void onInventoryClick(InventoryClickEvent var1);

    public void load() {
        this.passiveSelectorItem = new ItemBuilder(Material.ENDER_CHEST).setName(this.PASSIVE_SELECTOR_TITLE).build();
        this.passivePages.clear();
        KitApi.getInstance().getSupportedLanguages().forEach(supportedLanguage -> this.passivePages.put((Locale)supportedLanguage, new ArrayList()));
        this.createKitPages();
    }

    protected boolean isKitSelectorItem(ItemStack itemStack) {
        return this.passiveSelectorItem.isSimilar(itemStack);
    }

    private void createKitPages() {
        for (Locale language : KitApi.getInstance().getSupportedLanguages()) {
            int LAST_PAGE_SLOT = 18;
            int NEXT_PAGE_SLOT = 26;
            for (int i = 0; i < this.pageAmount(); ++i) {
                Inventory kitSelectorPage = Bukkit.createInventory(null, (int)45, (String)(this.PASSIVE_SELECTOR_TITLE + " " + (i + 1)));
                int inventorySlot = 1;
                int start = i * this.MAX_AMOUNT_OF_PASSIVES;
                int end = Math.min(i * this.MAX_AMOUNT_OF_PASSIVES + this.MAX_AMOUNT_OF_PASSIVES, KitApi.getInstance().getEnabledPassives().size());
                for (int j = start; j < end; ++j) {
                    inventorySlot = this.inventorySlotNumber(inventorySlot);
                    AbstractKit kit = KitApi.getInstance().getAlphabeticallyPassive(j);
                    kitSelectorPage.setItem(inventorySlot, kit.getDisplayItem(language));
                    ++inventorySlot;
                }
                kitSelectorPage.setItem(LAST_PAGE_SLOT, this.LAST_PAGE_ITEM);
                kitSelectorPage.setItem(NEXT_PAGE_SLOT, this.NEXT_PAGE_ITEM);
                List<Inventory> kitPages = this.passivePages.get(language);
                kitPages.add(kitSelectorPage);
            }
            if (this.pageAmount() != 0) continue;
            Inventory kitSelectorPage = Bukkit.createInventory(null, (int)45, (String)(this.PASSIVE_SELECTOR_TITLE + " 1"));
            kitSelectorPage.setItem(LAST_PAGE_SLOT, this.LAST_PAGE_ITEM);
            kitSelectorPage.setItem(NEXT_PAGE_SLOT, this.NEXT_PAGE_ITEM);
            List<Inventory> kitPages = this.passivePages.get(language);
            kitPages.add(kitSelectorPage);
        }
    }

    public Inventory getPage(int index, Locale locale) {
        return index >= 0 && index < this.passivePages.get(locale).size() ? this.passivePages.get(locale).get(index) : null;
    }

    private int pageAmount() {
        int enabledKits = KitApi.getInstance().getEnabledPassives().size();
        int safeAmount = enabledKits / this.MAX_AMOUNT_OF_PASSIVES;
        int rest = enabledKits % this.MAX_AMOUNT_OF_PASSIVES;
        if (rest > 0) {
            ++safeAmount;
        }
        return safeAmount;
    }

    private int inventorySlotNumber(int slot) {
        switch (slot) {
            case 8: {
                return 10;
            }
            case 17: {
                return 19;
            }
            case 26: {
                return 28;
            }
            case 35: {
                return 37;
            }
        }
        return slot;
    }

    protected void openFirstPage(Player player) {
        Inventory page = this.getPage(0, ChatUtils.locale((UUID)player.getUniqueId()));
        if (page != null) {
            player.openInventory(page);
        }
    }

    protected boolean nextPage(String title, ItemStack clickedItem, Player player) {
        if (clickedItem.isSimilar(this.NEXT_PAGE_ITEM)) {
            String pageNumber = title.substring(title.length() - 1);
            Inventory page = this.getPage(Integer.parseInt(pageNumber), ChatUtils.locale((Player)player));
            if (page != null) {
                player.openInventory(page);
            }
            return true;
        }
        return false;
    }

    protected boolean lastPage(String title, ItemStack clickedItem, Player player) {
        if (clickedItem.isSimilar(this.LAST_PAGE_ITEM)) {
            String pageNumber = title.substring(title.length() - 1);
            Inventory page = this.getPage(Integer.parseInt(pageNumber) - 1 - 1, ChatUtils.locale((Player)player));
            if (page != null) {
                player.openInventory(page);
            }
            return true;
        }
        return false;
    }

    public ItemStack getPassiveSelectorItem() {
        return this.passiveSelectorItem;
    }
}

