/*
 * Decompiled with CFR 0.152.
 */
package de.hglabor.plugins.kitapi.kit.kits.grappler;

import de.hglabor.plugins.kitapi.KitApi;
import de.hglabor.plugins.kitapi.kit.AbstractKit;
import de.hglabor.plugins.kitapi.kit.config.KitMetaData;
import de.hglabor.plugins.kitapi.kit.events.KitEvent;
import de.hglabor.plugins.kitapi.kit.kits.grappler.GrapplerHookEntity;
import de.hglabor.plugins.kitapi.kit.settings.FloatArg;
import de.hglabor.plugins.kitapi.kit.settings.IntArg;
import de.hglabor.plugins.kitapi.player.KitPlayer;
import de.hglabor.utils.localization.Localization;
import de.hglabor.utils.noriskutils.ChatUtils;
import de.hglabor.utils.noriskutils.ItemBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.World;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_18_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_18_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_18_R1.entity.CraftPlayer;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.CrossbowMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class GrapplerKit
extends AbstractKit
implements Listener {
    public static final GrapplerKit INSTANCE = new GrapplerKit();
    private final ItemStack grapplerArrow;
    private final Map<UUID, Long> onCooldown;
    @IntArg
    private final int spamCooldown;
    @IntArg
    private final int maxUses;
    private final String hasShotKey = this.getName() + "hasShoot";
    private final String projectileKey = this.getName() + "projectile";
    @FloatArg(min=0.0f)
    private final float cooldown;

    private GrapplerKit() {
        super("Grappler", Material.CROSSBOW);
        this.cooldown = 45.0f;
        this.spamCooldown = 2;
        this.maxUses = 2;
        this.grapplerArrow = new ItemBuilder(Material.ARROW).setName("Grappler Arrow").build();
        this.onCooldown = new HashMap<UUID, Long>();
        this.setMainKitItem(new ItemBuilder(Material.CROSSBOW).setUnbreakable(true).build());
    }

    @Override
    public void onDisable(KitPlayer kitPlayer) {
        if (!kitPlayer.isValid()) {
            return;
        }
        if (kitPlayer.getKitAttribute(this.projectileKey) != null) {
            Projectile projectile = (Projectile)kitPlayer.getKitAttribute(this.projectileKey);
            this.removeGrapplerHook(projectile);
            projectile.remove();
        }
    }

    @EventHandler
    public void onGrapplerArrowHitEvent(ProjectileHitEvent event) {
        Projectile projectile = event.getEntity();
        if (projectile.hasMetadata(KitMetaData.GRAPPLER_ARROW.getKey())) {
            Player shooter = (Player)event.getEntity().getShooter();
            if (shooter != null) {
                this.removeGrapplerHook(projectile);
                boolean inCombat = projectile.hasMetadata(KitMetaData.KITPLAYER_IS_IN_COMBAT.getKey());
                Vector vector = this.getVectorForPoints(shooter.getLocation(), event.getEntity().getLocation(), inCombat);
                Bukkit.getScheduler().runTaskLater((Plugin)KitApi.getInstance().getPlugin(), () -> {
                    KitPlayer player = KitApi.getInstance().getPlayer(shooter);
                    if (!player.isValid() && !player.hasKit(this)) {
                        return;
                    }
                    shooter.setGravity(true);
                    shooter.setVelocity(vector);
                    if (inCombat) {
                        shooter.sendMessage(Localization.INSTANCE.getMessage("grappler.inCombat", ChatUtils.locale((Player)shooter)));
                    }
                }, 0L);
            }
            event.setCancelled(true);
            projectile.remove();
        }
    }

    @Override
    @KitEvent
    public void onProjectileLaunch(ProjectileLaunchEvent event) {
        Player player = (Player)event.getEntity().getShooter();
        if (player == null) {
            return;
        }
        KitPlayer kitPlayer = KitApi.getInstance().getPlayer(player);
        if (((Boolean)kitPlayer.getKitAttribute(this.hasShotKey)).booleanValue()) {
            kitPlayer.putKitAttribute(this.hasShotKey, false);
            Arrow projectile = (Arrow)event.getEntity();
            kitPlayer.putKitAttribute(this.projectileKey, projectile);
            projectile.setCritical(false);
            projectile.setMetadata(KitMetaData.GRAPPLER_ARROW.getKey(), (MetadataValue)new FixedMetadataValue((Plugin)KitApi.getInstance().getPlugin(), (Object)""));
            GrapplerHookEntity grapplerHookEntity = new GrapplerHookEntity((EntityHuman)((CraftPlayer)player).getHandle(), (World)((CraftWorld)player.getWorld()).getHandle(), 1, 1);
            ((CraftWorld)player.getWorld()).getHandle().b((net.minecraft.world.entity.Entity)grapplerHookEntity);
            projectile.addPassenger((Entity)grapplerHookEntity.getBukkitEntity());
            if (kitPlayer.isInCombat()) {
                projectile.setMetadata(KitMetaData.KITPLAYER_IS_IN_COMBAT.getKey(), (MetadataValue)new FixedMetadataValue((Plugin)KitApi.getInstance().getPlugin(), (Object)""));
                KitApi.getInstance().checkUsesForCooldown(player, (AbstractKit)this, this.maxUses);
            }
        }
    }

    @Override
    @KitEvent
    public void onPlayerRightClickKitItem(PlayerInteractEvent event, KitPlayer kitPlayer) {
        Player player = event.getPlayer();
        if (this.hasInternalCooldown(player)) {
            player.sendMessage(Localization.INSTANCE.getMessage("kit.spamPrevention", ChatUtils.locale((Player)player)));
            return;
        }
        this.getCrossBow(player).ifPresent(itemStack -> {
            CrossbowMeta crossbowMeta = (CrossbowMeta)itemStack.getItemMeta();
            if (!crossbowMeta.hasChargedProjectiles()) {
                crossbowMeta.addChargedProjectile(this.grapplerArrow);
                kitPlayer.putKitAttribute(this.hasShotKey, true);
                itemStack.setItemMeta((ItemMeta)crossbowMeta);
                this.onCooldown.put(player.getUniqueId(), System.currentTimeMillis() + (long)this.spamCooldown * 1000L);
            }
        });
    }

    private boolean hasInternalCooldown(Player player) {
        if (this.onCooldown.containsKey(player.getUniqueId())) {
            Long coolDown = this.onCooldown.get(player.getUniqueId());
            if (System.currentTimeMillis() > coolDown) {
                this.onCooldown.remove(player.getUniqueId());
                return false;
            }
            return true;
        }
        return false;
    }

    private Vector getVectorForPoints(Location l1, Location l2, boolean inCombat) {
        double boost = inCombat ? 0.1 : 1.0;
        double height = inCombat ? -0.008 : -0.08;
        double t = l2.distance(l1);
        double vX = (boost + 0.07 * t) * (l2.getX() - l1.getX()) / t;
        double vY = (boost + 0.03 * t) * (l2.getY() - l1.getY()) / t - 0.5 * height * t;
        double vZ = (boost + 0.07 * t) * (l2.getZ() - l1.getZ()) / t;
        return new Vector(vX, vY, vZ);
    }

    private void removeGrapplerHook(Projectile projectile) {
        for (Entity passenger : projectile.getPassengers()) {
            if (!(((CraftEntity)passenger).getHandle() instanceof GrapplerHookEntity)) continue;
            ((GrapplerHookEntity)((CraftEntity)passenger).getHandle()).remove();
        }
    }

    private Optional<ItemStack> getCrossBow(Player player) {
        if (player.getInventory().getItemInMainHand().isSimilar(this.getMainKitItem())) {
            return Optional.of(player.getInventory().getItemInMainHand());
        }
        if (player.getInventory().getItemInOffHand().isSimilar(this.getMainKitItem())) {
            return Optional.of(player.getInventory().getItemInOffHand());
        }
        return Optional.empty();
    }

    @Override
    public float getCooldown() {
        return this.cooldown;
    }
}

