/*
 * Decompiled with CFR 0.152.
 */
package de.hglabor.plugins.kitapi.kit.kits.endermage;

import de.hglabor.plugins.kitapi.KitApi;
import de.hglabor.plugins.kitapi.kit.AbstractKit;
import de.hglabor.plugins.kitapi.kit.config.KitMetaData;
import de.hglabor.plugins.kitapi.kit.kits.endermage.EndermageKit;
import de.hglabor.plugins.kitapi.kit.kits.endermage.EndermageProperties;
import de.hglabor.plugins.kitapi.player.KitPlayer;
import de.hglabor.plugins.kitapi.util.Utils;
import de.hglabor.utils.localization.Localization;
import de.hglabor.utils.noriskutils.ChatUtils;
import java.util.Locale;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class EndermageSearch
extends BukkitRunnable {
    protected final int searchDuration;
    protected final Block endermagePortal;
    protected final Material oldBlockType;
    protected final BlockData oldBlockData;
    protected final Player player;
    protected final KitPlayer kitPlayer;
    protected final World world;
    protected final JavaPlugin plugin;
    protected final double radius;
    protected int counter;
    protected int magedPeople;
    protected boolean isSearchingForPlayers;
    protected boolean hasMaged;

    protected EndermageSearch(Player mage, Block endermagePortal, BlockData oldBlockData, Material oldBlockType) {
        this.player = mage;
        this.world = mage.getWorld();
        this.plugin = KitApi.getInstance().getPlugin();
        this.isSearchingForPlayers = true;
        this.kitPlayer = KitApi.getInstance().getPlayer(mage);
        this.searchDuration = EndermageKit.INSTANCE.getSearchTime();
        this.radius = EndermageKit.INSTANCE.getSearchRadius();
        this.endermagePortal = endermagePortal;
        this.oldBlockData = oldBlockData;
        this.oldBlockType = oldBlockType;
    }

    private void removeEndermageMetaDataLater(Player player, int delay) {
        KitPlayer kitPlayer = KitApi.getInstance().getPlayer(player);
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            EndermageProperties endermageProperties = (EndermageProperties)kitPlayer.getKitAttribute(EndermageKit.INSTANCE.getHasBeenMagedKey());
            if (endermageProperties == null) {
                player.removeMetadata(EndermageKit.INSTANCE.getHasBeenMagedKey(), (Plugin)this.plugin);
                player.sendMessage(Localization.INSTANCE.getMessage("endermage.invincibilityExpired", ChatUtils.locale((Player)player)));
            } else if (endermageProperties.getMagedTimeStamp() + (long)delay * 1000L <= System.currentTimeMillis()) {
                player.removeMetadata(EndermageKit.INSTANCE.getHasBeenMagedKey(), (Plugin)this.plugin);
                player.sendMessage(Localization.INSTANCE.getMessage("endermage.invincibilityExpired", ChatUtils.locale((Player)player)));
            }
        }, (long)delay * 21L);
    }

    public void run() {
        ++this.counter;
        if (this.isSearchingForPlayers && this.counter <= this.searchDuration) {
            int magedPeople = 0;
            for (Player nearbyPlayer : this.world.getNearbyPlayers(this.endermagePortal.getLocation(), this.radius, (double)this.world.getMaxHeight())) {
                KitPlayer nearbyKitPlayer = KitApi.getInstance().getPlayer(nearbyPlayer);
                if (nearbyPlayer == this.player || nearbyKitPlayer.hasKit(EndermageKit.INSTANCE) || nearbyPlayer.hasMetadata(KitMetaData.INGLADIATOR.getKey()) || !nearbyKitPlayer.isValid() || this.endermagePortal.getLocation().getY() > nearbyPlayer.getLocation().getY() - 3.0 && this.endermagePortal.getLocation().getY() < nearbyPlayer.getLocation().getY() + 3.0) continue;
                this.mageTeleportPlayer(nearbyPlayer, false);
                this.hasMaged = true;
                ++magedPeople;
            }
            this.magedPeople = magedPeople;
            if (this.hasMaged) {
                this.endSearching();
                this.mageTeleportPlayer(this.player, true);
            }
        } else {
            this.endSearching();
        }
    }

    protected void mageTeleportPlayer(Player player, boolean isMage) {
        int delay = EndermageKit.INSTANCE.getInvulnerabilityAfterMage();
        KitPlayer kitPlayer = KitApi.getInstance().getPlayer(player);
        Location teleportLocation = this.endermagePortal.getLocation().getBlock().getLocation().add(0.5, 1.0, 0.5);
        teleportLocation.setPitch(0.0f);
        teleportLocation.setYaw(0.0f);
        player.teleport(teleportLocation);
        player.leaveVehicle();
        player.setMetadata(EndermageKit.INSTANCE.getHasBeenMagedKey(), (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)""));
        kitPlayer.putKitAttribute(EndermageKit.INSTANCE.getHasBeenMagedKey(), new EndermageProperties(System.currentTimeMillis()));
        if (isMage) {
            player.sendMessage(Localization.t((String)"endermage.successfulTeleport", Map.of("amount", String.valueOf(this.magedPeople), "timeInSeconds", String.valueOf(delay)), (Locale)ChatUtils.locale((Player)player)));
        } else {
            player.sendMessage(Localization.t((String)"endermage.gotTeleported", Map.of("timeInSeconds", String.valueOf(delay)), (Locale)ChatUtils.locale((Player)player)));
        }
        this.removeEndermageMetaDataLater(player, delay);
    }

    protected void endSearching() {
        this.cancel();
        this.isSearchingForPlayers = false;
        KitApi.getInstance().checkUsesForCooldown(this.player, (AbstractKit)EndermageKit.INSTANCE, EndermageKit.INSTANCE.getMaxUses());
        if (!Utils.isUnbreakableLaborBlock(this.endermagePortal) && this.endermagePortal.getType() != Material.BEDROCK && !(this.endermagePortal.getState() instanceof InventoryHolder)) {
            this.endermagePortal.setType(this.oldBlockType);
        }
        this.endermagePortal.setBlockData(this.oldBlockData);
    }
}

