/*
 * Decompiled with CFR 0.152.
 */
package de.hglabor.plugins.kitapi.kit.kits.endermage;

import de.hglabor.plugins.kitapi.KitApi;
import de.hglabor.plugins.kitapi.kit.AbstractKit;
import de.hglabor.plugins.kitapi.kit.config.KitMetaData;
import de.hglabor.plugins.kitapi.kit.events.KitEvent;
import de.hglabor.plugins.kitapi.kit.kits.endermage.EndermageSearch;
import de.hglabor.plugins.kitapi.kit.settings.DoubleArg;
import de.hglabor.plugins.kitapi.kit.settings.FloatArg;
import de.hglabor.plugins.kitapi.kit.settings.IntArg;
import de.hglabor.plugins.kitapi.player.KitPlayer;
import de.hglabor.plugins.kitapi.util.Utils;
import de.hglabor.utils.localization.Localization;
import de.hglabor.utils.noriskutils.ChatUtils;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.Plugin;

public class EndermageKit
extends AbstractKit
implements Listener {
    public static final EndermageKit INSTANCE = new EndermageKit();
    @IntArg
    private final int maxUses;
    @IntArg
    private final int invulnerabilityAfterMage;
    @IntArg
    private final int searchTime;
    @DoubleArg
    private final double searchRadius;
    private final String attributeKey;
    private final String hasBeenMagedKey = this.getName() + "hasBeenMaged";
    @FloatArg(min=0.0f)
    private final float cooldown;

    private EndermageKit() {
        super("Endermage", Material.END_PORTAL_FRAME);
        this.cooldown = 15.0f;
        this.maxUses = 5;
        this.searchRadius = 4.0;
        this.invulnerabilityAfterMage = 5;
        this.searchTime = 5;
        this.attributeKey = this.getName() + "Runnable";
        this.setMainKitItem(this.getDisplayMaterial());
    }

    @Override
    public void onDeactivation(KitPlayer kitPlayer) {
        EndermageSearch endermageRunnable = (EndermageSearch)((Object)kitPlayer.getKitAttribute(this.attributeKey));
        if (endermageRunnable != null && endermageRunnable.isSearchingForPlayers) {
            endermageRunnable.endSearching();
        }
    }

    @Override
    @KitEvent
    public void onPlayerRightClickKitItem(PlayerInteractEvent event, KitPlayer kitPlayer) {
        Block endermagePortal = event.getClickedBlock();
        if (endermagePortal != null && !Utils.isUnbreakableLaborBlock(endermagePortal)) {
            Player player = event.getPlayer();
            if (endermagePortal.getLocation().add(0.0, 1.0, 0.0).getBlock().getType() != Material.AIR || endermagePortal.getLocation().add(0.0, 2.0, 0.0).getBlock().getType() != Material.AIR) {
                player.sendMessage(Localization.INSTANCE.getMessage("endermage.notEnoughSpace", ChatUtils.locale((Player)player)));
                return;
            }
            if (player.hasMetadata(KitMetaData.INGLADIATOR.getKey())) {
                return;
            }
            EndermageSearch endermageRunnable = (EndermageSearch)((Object)kitPlayer.getKitAttribute(this.attributeKey));
            if (endermageRunnable != null && endermageRunnable.isSearchingForPlayers) {
                player.sendMessage(Localization.INSTANCE.getMessage("endermage.alreadySearching", ChatUtils.locale((Player)player)));
                return;
            }
            BlockData oldBlockData = endermagePortal.getBlockData();
            Material oldBlock = endermagePortal.getType();
            endermagePortal.setType(Material.END_PORTAL_FRAME);
            EndermageSearch newEndermageRunnable = new EndermageSearch(player, endermagePortal, oldBlockData, oldBlock);
            kitPlayer.putKitAttribute(this.attributeKey, newEndermageRunnable);
            newEndermageRunnable.runTaskTimer((Plugin)KitApi.getInstance().getPlugin(), 0L, 20L);
        }
    }

    @EventHandler
    public void onMagedPlayerGetsDamaged(EntityDamageEvent event) {
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getEntity();
        if (player.hasMetadata(this.hasBeenMagedKey)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onMagedPlayerHitsEntity(EntityDamageByEntityEvent event) {
        if (!(event.getDamager() instanceof Player)) {
            return;
        }
        Player damager = (Player)event.getDamager();
        if (damager.hasMetadata(this.hasBeenMagedKey)) {
            event.setCancelled(true);
        }
    }

    public int getMaxUses() {
        return this.maxUses;
    }

    public double getSearchRadius() {
        return this.searchRadius;
    }

    public int getInvulnerabilityAfterMage() {
        return this.invulnerabilityAfterMage;
    }

    public int getSearchTime() {
        return this.searchTime;
    }

    public String getAttributeKey() {
        return this.attributeKey;
    }

    public String getHasBeenMagedKey() {
        return this.hasBeenMagedKey;
    }

    @Override
    public float getCooldown() {
        return this.cooldown;
    }
}

