/*
 * Decompiled with CFR 0.152.
 */
package de.hglabor.plugins.kitapi.kit.kits;

import de.hglabor.plugins.kitapi.KitApi;
import de.hglabor.plugins.kitapi.kit.AbstractKit;
import de.hglabor.plugins.kitapi.kit.events.KitEvent;
import de.hglabor.plugins.kitapi.kit.settings.IntArg;
import de.hglabor.plugins.kitapi.player.KitPlayer;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageByEntityEvent;

public class ZickZackKit
extends AbstractKit {
    public static final ZickZackKit INSTANCE = new ZickZackKit();
    @IntArg
    private final int likelihood;
    @IntArg
    private final int minCombo;
    private final String comboCounterKey = this.getName() + "combos";

    private ZickZackKit() {
        super("ZickZack", Material.DIAMOND_BLOCK);
        this.likelihood = 20;
        this.minCombo = 3;
    }

    @Override
    public void onEnable(KitPlayer kitPlayer) {
        kitPlayer.putKitAttribute(this.comboCounterKey, new HashMap());
    }

    @Override
    @KitEvent
    public void onPlayerAttacksLivingEntity(EntityDamageByEntityEvent e, KitPlayer attacker, LivingEntity entity) {
        if (!(e.getEntity() instanceof Player) || !(e.getDamager() instanceof Player)) {
            return;
        }
        Player enemy = (Player)entity;
        Map combo = (Map)attacker.getKitAttribute(this.comboCounterKey);
        if (!combo.containsKey(enemy.getUniqueId())) {
            combo.put(enemy.getUniqueId(), 0);
        } else if ((Integer)combo.get(enemy.getUniqueId()) < this.likelihood) {
            combo.replace(enemy.getUniqueId(), (Integer)combo.get(enemy.getUniqueId()) + 1);
        }
    }

    @Override
    public void onPlayerGetsAttackedByLivingEntity(EntityDamageByEntityEvent event, Player player, LivingEntity attacker) {
        if (!(attacker instanceof Player)) {
            return;
        }
        KitPlayer kitPlayer = KitApi.getInstance().getPlayer(player);
        Map combo = (Map)kitPlayer.getKitAttribute(this.comboCounterKey);
        if (combo.containsKey(attacker.getUniqueId())) {
            int comboAmount = (Integer)combo.get(attacker.getUniqueId());
            if (comboAmount < this.minCombo) {
                return;
            }
            int chance = new Random().nextInt(this.likelihood) + 1;
            if (chance > this.likelihood - comboAmount) {
                event.setCancelled(true);
                combo.replace(attacker.getUniqueId(), (Integer)combo.get(attacker.getUniqueId()) - 1);
                ((Player)attacker).playSound(attacker.getLocation(), Sound.BLOCK_BUBBLE_COLUMN_WHIRLPOOL_INSIDE, 100.0f, 100.0f);
                player.playSound(player.getLocation(), Sound.BLOCK_BUBBLE_COLUMN_WHIRLPOOL_INSIDE, 100.0f, 100.0f);
            } else {
                combo.replace(attacker.getUniqueId(), 0);
            }
        }
    }
}

