/*
 * Decompiled with CFR 0.152.
 */
package de.hglabor.plugins.kitapi.kit.kits;

import de.hglabor.plugins.kitapi.KitApi;
import de.hglabor.plugins.kitapi.kit.AbstractKit;
import de.hglabor.plugins.kitapi.kit.events.KitEvent;
import de.hglabor.plugins.kitapi.kit.items.KitItemBuilder;
import de.hglabor.plugins.kitapi.kit.settings.BetaKit;
import de.hglabor.plugins.kitapi.kit.settings.IntArg;
import de.hglabor.plugins.kitapi.player.KitPlayer;
import de.hglabor.plugins.kitapi.util.BukkitUtils;
import java.util.ArrayList;
import java.util.UUID;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

@BetaKit
public class VentKit
extends AbstractKit
implements Listener {
    public static final VentKit INSTANCE = new VentKit();
    private static final String IMPOSTER_HEAD = "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYTdkNWViMGFlYTVkNjFiYTNmZjQ5OTY0MTZhOTAwOTZhOWQ3NzYwOWViY2QzYjMwOGY5MDZhZTg4OGE0NWY2ZCJ9fX0=";
    private static final String VENT_OWNER = "vent-owner";
    private static final String VENT_PAIR = "vent-pair";
    private final String lastVentKey;
    private final String ventListKey;
    @IntArg
    private final int maxAmountOfVentPairs;

    private VentKit() {
        super("Vent");
        this.setDisplayItem(new KitItemBuilder(Material.PLAYER_HEAD).setPlayerSkullSkin(IMPOSTER_HEAD).build());
        this.setMainKitItem(Material.IRON_TRAPDOOR);
        this.maxAmountOfVentPairs = 4;
        this.ventListKey = "ventListKey" + this.getName();
        this.lastVentKey = "lastVentKey" + this.getName();
    }

    @Override
    public void onDeactivation(KitPlayer kitPlayer) {
        ArrayList ventBlocks = kitPlayer.getKitAttributeOrDefault(this.ventListKey, new ArrayList());
        for (Block ventBlock : ventBlocks) {
            if (!ventBlock.hasMetadata(VENT_OWNER) && !ventBlock.hasMetadata(VENT_PAIR)) continue;
            ventBlock.removeMetadata(VENT_OWNER, (Plugin)KitApi.getInstance().getPlugin());
            ventBlock.removeMetadata(VENT_PAIR, (Plugin)KitApi.getInstance().getPlugin());
            if (!ventBlock.getType().equals((Object)Material.IRON_TRAPDOOR)) continue;
            ventBlock.setType(Material.AIR);
        }
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        this.removeVentAndNotify(event.getBlock());
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (event.getClickedBlock() != null && event.getClickedBlock().hasMetadata(VENT_PAIR)) {
            Player player = event.getPlayer();
            player.playSound(player.getLocation(), Sound.BLOCK_WOODEN_TRAPDOOR_OPEN, 1.0f, 1.0f);
            Block vent = event.getClickedBlock();
            Block ventPair = (Block)((MetadataValue)vent.getMetadata(VENT_PAIR).get(0)).value();
            if (ventPair != null) {
                player.teleport(ventPair.getLocation());
                UUID ventOwnerId = this.getVentOwnerId(vent);
                if (ventOwnerId != player.getUniqueId()) {
                    BukkitUtils.optionalPlayer(ventOwnerId).ifPresent(imposter -> {
                        imposter.playSound(imposter.getLocation(), Sound.BLOCK_WOODEN_TRAPDOOR_OPEN, 1.0f, 1.0f);
                        imposter.sendMessage(ChatColor.GRAY + player.getName() + " hat deinen Vent benutzt.");
                    });
                }
            }
        }
    }

    @Override
    @KitEvent
    public void onPlayerRightClickKitItem(PlayerInteractEvent event, KitPlayer kitPlayer) {
        Player player = event.getPlayer();
        ArrayList<Block> ventBlocks = kitPlayer.getKitAttributeOrDefault(this.ventListKey, new ArrayList());
        if (ventBlocks.size() >= this.maxAmountOfVentPairs) {
            player.sendMessage(ChatColor.RED + "Du hast die maximale Anzahl an Vents platziert.");
            return;
        }
        if (event.getClickedBlock() != null) {
            Block clickedBlock = event.getClickedBlock().getRelative(event.getBlockFace());
            clickedBlock.setType(Material.IRON_TRAPDOOR);
            clickedBlock.setMetadata(VENT_OWNER, (MetadataValue)new FixedMetadataValue((Plugin)KitApi.getInstance().getPlugin(), (Object)player.getUniqueId()));
            ventBlocks.add(clickedBlock);
            kitPlayer.putKitAttribute(this.ventListKey, ventBlocks);
            Block lastVent = (Block)kitPlayer.getKitAttribute(this.lastVentKey);
            if (lastVent != null) {
                lastVent.setMetadata(VENT_PAIR, (MetadataValue)new FixedMetadataValue((Plugin)KitApi.getInstance().getPlugin(), (Object)clickedBlock));
                clickedBlock.setMetadata(VENT_PAIR, (MetadataValue)new FixedMetadataValue((Plugin)KitApi.getInstance().getPlugin(), (Object)lastVent));
                BukkitUtils.playSound(player, Sound.BLOCK_BEACON_ACTIVATE);
                player.sendMessage(ChatColor.GREEN + "Vents erfolgreich verbunden");
                kitPlayer.putKitAttribute(this.lastVentKey, null);
            } else {
                BukkitUtils.playSound(player, Sound.BLOCK_METAL_PLACE);
                player.sendMessage(ChatColor.GREEN + "Erster Vent erfolgreich platziert.");
                kitPlayer.putKitAttribute(this.lastVentKey, clickedBlock);
            }
        }
    }

    private void removeVentAndNotify(Block block) {
        if (this.hasVentOwner(block)) {
            block.setType(Material.AIR);
            UUID ventOwnerId = this.getVentOwnerId(block);
            block.removeMetadata(VENT_OWNER, (Plugin)KitApi.getInstance().getPlugin());
            KitPlayer kitPlayer = KitApi.getInstance().getPlayerSupplier().getKitPlayer(ventOwnerId);
            ArrayList ventBlocks = kitPlayer.getKitAttributeOrDefault(this.ventListKey, new ArrayList());
            ventBlocks.remove(block);
            kitPlayer.putKitAttribute(this.ventListKey, ventBlocks);
            if (this.hasVentPair(block)) {
                Block ventPair = this.getVentPair(block);
                ventPair.removeMetadata(VENT_PAIR, (Plugin)KitApi.getInstance().getPlugin());
                block.removeMetadata(VENT_PAIR, (Plugin)KitApi.getInstance().getPlugin());
                this.removeVentAndNotify(ventPair);
            }
            BukkitUtils.optionalPlayer(ventOwnerId).ifPresent(player -> {
                BukkitUtils.playSound(player, Sound.BLOCK_BEACON_DEACTIVATE, 1.0f, 1.0f);
                player.sendMessage(ChatColor.RED + "Dein Vent bei " + this.printVentLocation(block) + ChatColor.RED + " wurde zerst\u00f6rt.");
            });
        }
    }

    private String printVentLocation(Block block) {
        Location location = block.getLocation();
        return ChatColor.GOLD + "[X: " + location.getBlockX() + " Y: " + location.getBlockY() + " Z: " + location.getBlockZ() + "]";
    }

    private boolean hasVentOwner(Block block) {
        return block.hasMetadata(VENT_OWNER);
    }

    private boolean hasVentPair(Block block) {
        return block.hasMetadata(VENT_PAIR);
    }

    private UUID getVentOwnerId(Block block) {
        return (UUID)((MetadataValue)block.getMetadata(VENT_OWNER).get(0)).value();
    }

    private Block getVentPair(Block block) {
        return (Block)((MetadataValue)block.getMetadata(VENT_PAIR).get(0)).value();
    }
}

