/*
 * Decompiled with CFR 0.152.
 */
package de.hglabor.plugins.kitapi.kit.kits;

import com.google.common.collect.ImmutableMap;
import de.hglabor.plugins.kitapi.kit.AbstractKit;
import de.hglabor.plugins.kitapi.kit.events.KitEvent;
import de.hglabor.plugins.kitapi.kit.settings.DoubleArg;
import de.hglabor.plugins.kitapi.player.KitPlayer;
import de.hglabor.utils.localization.Localization;
import de.hglabor.utils.noriskutils.ChatUtils;
import java.util.Locale;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.PlayerDeathEvent;

public class VampireKit
extends AbstractKit {
    public static final VampireKit INSTANCE = new VampireKit();
    @DoubleArg
    private final double heartsProKill;
    @DoubleArg
    private final double defaultHealth;
    @DoubleArg
    private final double maxHealth;
    private final String currentHealthKey = this.getName() + "currentHealth";

    private VampireKit() {
        super("Vampire", Material.POPPY);
        this.heartsProKill = 2.0;
        this.defaultHealth = 20.0;
        this.maxHealth = 40.0;
    }

    @Override
    public void onEnable(KitPlayer kitPlayer) {
        kitPlayer.getBukkitPlayer().ifPresent(player -> player.setMaxHealth(kitPlayer.getKitAttributeOrDefault(this.currentHealthKey, this.defaultHealth).doubleValue()));
    }

    @Override
    public void onDeactivation(KitPlayer kitPlayer) {
        kitPlayer.getBukkitPlayer().ifPresent(player -> player.setMaxHealth(this.defaultHealth));
    }

    @Override
    @KitEvent(clazz=PlayerDeathEvent.class)
    public void onPlayerKillsPlayer(KitPlayer killer, KitPlayer dead) {
        killer.getBukkitPlayer().ifPresent(player -> {
            player.sendMessage(Localization.INSTANCE.getMessage("vampire.extraHealth", (Map)ImmutableMap.of((Object)"hearts", (Object)String.valueOf(this.heartsProKill)), ChatUtils.locale((Player)player)));
            double newHealth = player.getMaxHealth() + this.heartsProKill;
            if (newHealth <= this.maxHealth) {
                player.setMaxHealth(newHealth);
                player.setHealth(player.getMaxHealth());
                killer.putKitAttribute(this.currentHealthKey, player.getMaxHealth());
            } else {
                player.sendMessage(Localization.t((String)"vampire.maxHealth", (Locale)ChatUtils.locale((Player)player)));
            }
        });
    }

    @Override
    @KitEvent
    public void onPlayerKillsLivingEntity(EntityDeathEvent event, Player killer, Entity entity) {
        killer.sendMessage(Localization.INSTANCE.getMessage("vampire.restoredHealth", ChatUtils.locale((Player)killer)));
        killer.setHealth(killer.getMaxHealth());
    }
}

