/*
 * Decompiled with CFR 0.152.
 */
package de.hglabor.plugins.kitapi.kit.kits;

import de.hglabor.plugins.kitapi.KitApi;
import de.hglabor.plugins.kitapi.kit.AbstractKit;
import de.hglabor.plugins.kitapi.kit.events.KitEvent;
import de.hglabor.plugins.kitapi.kit.settings.DoubleArg;
import de.hglabor.plugins.kitapi.kit.settings.FloatArg;
import de.hglabor.plugins.kitapi.player.KitPlayer;
import de.hglabor.plugins.kitapi.util.Utils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class UltimatoKit
extends AbstractKit {
    public static final UltimatoKit INSTANCE = new UltimatoKit();
    private static final String ultimatoFightKey = "ultimatoFight";
    @DoubleArg
    private final double radius;
    @DoubleArg
    private final double strength;
    @FloatArg
    private final float cooldown;

    private UltimatoKit() {
        super("Ultimato", Material.RED_STAINED_GLASS_PANE);
        this.radius = 10.0;
        this.strength = 2.3;
        this.cooldown = 2.0f;
        this.setMainKitItem(this.getDisplayMaterial());
    }

    @Override
    @KitEvent
    public void onHitLivingEntityWithKitItem(EntityDamageByEntityEvent event, KitPlayer attacker, LivingEntity entity) {
        if (!(entity instanceof Player)) {
            return;
        }
        KitPlayer kitPlayerEntity = KitApi.getInstance().getPlayer((Player)entity);
        if (attacker.getBukkitPlayer().isEmpty()) {
            return;
        }
        if (attacker.getKitAttribute(ultimatoFightKey) == null) {
            if (kitPlayerEntity.getKitAttribute(ultimatoFightKey) != null) {
                attacker.getBukkitPlayer().ifPresent(player -> player.sendMessage(ChatColor.RED + "You can't attack someone who is already in a fight"));
                return;
            }
            Fight fight = new Fight(attacker.getBukkitPlayer().get(), (Player)entity, this.radius, this.strength, attacker.getBukkitPlayer().get().getLocation());
            entity.getWorld().playSound(entity.getLocation(), Sound.ENTITY_GHAST_SCREAM, 1.0f, 1.0f);
            kitPlayerEntity.putKitAttribute(ultimatoFightKey, fight);
            attacker.putKitAttribute(ultimatoFightKey, fight);
            Bukkit.getScheduler().runTaskTimer((Plugin)KitApi.getInstance().getPlugin(), task -> {
                boolean shouldCancel = fight.tick();
                if (shouldCancel) {
                    task.cancel();
                    kitPlayerEntity.putKitAttribute(ultimatoFightKey, null);
                    attacker.putKitAttribute(ultimatoFightKey, null);
                    attacker.activateKitCooldown(INSTANCE);
                }
            }, 0L, 1L);
        } else {
            attacker.getBukkitPlayer().ifPresent(player -> player.sendMessage(ChatColor.RED + "You are already in a fight"));
        }
    }

    @Override
    public float getCooldown() {
        return this.cooldown;
    }

    public static class Fight {
        private final Player attacker;
        private final Player victim;
        private final double radius;
        private final double strength;
        private final Location center;

        public Fight(Player attacker, Player victim, double radius, double strength, Location center) {
            this.attacker = attacker;
            this.victim = victim;
            this.radius = radius;
            this.strength = strength;
            this.center = center;
        }

        public Player getAttacker() {
            return this.attacker;
        }

        public Player getVictim() {
            return this.victim;
        }

        public double getRadius() {
            return this.radius;
        }

        public double getStrength() {
            return this.strength;
        }

        public Location getCenter() {
            return this.center;
        }

        public boolean tick() {
            KitPlayer attackerKitPlayer = KitApi.getInstance().getPlayer(this.attacker);
            KitPlayer victimKitPlayer = KitApi.getInstance().getPlayer(this.victim);
            if (!attackerKitPlayer.isValid() || !victimKitPlayer.isValid()) {
                return true;
            }
            if (attackerKitPlayer.areKitsDisabled()) {
                return true;
            }
            if (this.victim.getLocation().distance(this.center) >= this.radius + 6.0) {
                return true;
            }
            if (this.attacker.getLocation().distance(this.center) >= this.radius + 6.0) {
                return true;
            }
            for (Entity otherEntities : this.center.getNearbyEntities(this.radius, this.radius, this.radius)) {
                if (!(otherEntities.getLocation().distance(this.center) >= this.radius)) continue;
                Vector direction = this.center.toVector().subtract(otherEntities.getLocation().toVector()).normalize();
                if (otherEntities == this.victim || otherEntities == this.attacker) {
                    otherEntities.setVelocity(direction.multiply(this.getStrength()));
                    continue;
                }
                otherEntities.setVelocity(direction.multiply(-(this.getStrength() / 2.0)));
            }
            Utils.drawCircle(this.radius, this.getCenter(), Particle.REDSTONE, new Particle.DustOptions(Color.RED, 1.0f));
            Utils.drawCircle(this.radius, this.getCenter().clone().add(0.0, 1.0, 0.0), Particle.REDSTONE, new Particle.DustOptions(Color.RED, 1.0f));
            return false;
        }
    }
}

