/*
 * Decompiled with CFR 0.152.
 */
package de.hglabor.plugins.kitapi.kit.kits;

import de.hglabor.plugins.kitapi.KitApi;
import de.hglabor.plugins.kitapi.kit.AbstractKit;
import de.hglabor.plugins.kitapi.kit.events.KitEvent;
import de.hglabor.plugins.kitapi.kit.settings.DoubleArg;
import de.hglabor.plugins.kitapi.kit.settings.FloatArg;
import de.hglabor.plugins.kitapi.kit.settings.IntArg;
import de.hglabor.plugins.kitapi.player.KitPlayer;
import de.hglabor.utils.noriskutils.ItemBuilder;
import java.util.Random;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.LlamaSpit;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class SpitKit
extends AbstractKit
implements Listener {
    public static final SpitKit INSTANCE = new SpitKit();
    @FloatArg(min=0.0f)
    private final float cooldown;
    private final String spitProjectileKey = this.getName() + " Soup";
    @DoubleArg
    private final double spitDamage;
    @IntArg
    private final int spitSoupHealing;

    private SpitKit() {
        super("Spit", Material.GHAST_TEAR);
        this.cooldown = 10.0f;
        this.spitSoupHealing = 3;
        this.spitDamage = 4.0;
        this.setMainKitItem(this.getDisplayMaterial());
    }

    @Override
    @KitEvent
    public void onPlayerRightClickKitItem(PlayerInteractEvent event, KitPlayer kitPlayer) {
        Player player = event.getPlayer();
        Projectile entity = player.launchProjectile(LlamaSpit.class);
        entity.setMetadata(this.spitProjectileKey, (MetadataValue)new FixedMetadataValue((Plugin)KitApi.getInstance().getPlugin(), (Object)""));
        player.playSound(player.getLocation(), Sound.ENTITY_LLAMA_SPIT, 100.0f, 100.0f);
        kitPlayer.activateKitCooldown(this);
    }

    @EventHandler
    public void onSpitHit(EntityDamageByEntityEvent event) {
        if (!(event.getEntity() instanceof Player) || !(event.getDamager() instanceof LlamaSpit)) {
            return;
        }
        if (!event.getDamager().hasMetadata(this.spitProjectileKey)) {
            return;
        }
        Player player = (Player)event.getEntity();
        event.setDamage(this.spitDamage);
        if (player.getInventory().contains(Material.MUSHROOM_STEW)) {
            this.spitInSoup(player);
        }
    }

    private void spitInSoup(Player player) {
        int random = new Random().nextInt(35) + 1;
        ItemStack randomItem = player.getInventory().getItem(random);
        if (randomItem != null) {
            if (randomItem.getType().equals((Object)Material.MUSHROOM_STEW)) {
                ItemStack itemStack = new ItemBuilder(Material.SUSPICIOUS_STEW).setName(this.spitProjectileKey).build();
                player.getInventory().setItem(random, itemStack);
            } else {
                this.spitInSoup(player);
            }
        }
    }

    public String getSpitProjectileKey() {
        return this.spitProjectileKey;
    }

    public int getSpitSoupHealing() {
        return this.spitSoupHealing;
    }

    @Override
    public float getCooldown() {
        return this.cooldown;
    }
}

