/*
 * Decompiled with CFR 0.152.
 */
package de.hglabor.plugins.kitapi.kit.kits;

import de.hglabor.plugins.kitapi.KitApi;
import de.hglabor.plugins.kitapi.kit.AbstractKit;
import de.hglabor.plugins.kitapi.kit.events.KitEvent;
import de.hglabor.plugins.kitapi.kit.settings.IntArg;
import de.hglabor.plugins.kitapi.kit.settings.PotionEffectArg;
import de.hglabor.plugins.kitapi.kit.settings.SoundArg;
import de.hglabor.plugins.kitapi.player.KitPlayer;
import de.hglabor.utils.localization.Localization;
import de.hglabor.utils.noriskutils.ChatUtils;
import de.hglabor.utils.noriskutils.ItemBuilder;
import java.util.Arrays;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

public class SoulstealerKit
extends AbstractKit
implements Listener {
    public static final SoulstealerKit INSTANCE = new SoulstealerKit();
    private final String respawnKey = this.getName() + "respawn";
    private final String runnableKey = this.getName() + "deathTimer";
    @PotionEffectArg
    private final PotionEffectType effectOnDeath = PotionEffectType.SPEED;
    @IntArg
    private final int effectAmplifier;
    @IntArg
    private final int effectDuration;
    @SoundArg
    private final Sound deathSound;
    private final ItemStack firstSword;
    private final String soulstealerSwordName = ChatColor.BLACK.toString() + ChatColor.BOLD + "SOULSTEALER";

    private SoulstealerKit() {
        super("Soulstealer", Material.BONE);
        this.effectAmplifier = 2;
        this.effectDuration = 10;
        this.deathSound = Sound.ENTITY_WOLF_HOWL;
        this.firstSword = new ItemBuilder(Material.IRON_SWORD).setName(this.soulstealerSwordName).build();
    }

    @Override
    public void onDisable(KitPlayer kitPlayer) {
        DeathTimer deathTimer = (DeathTimer)((Object)kitPlayer.getKitAttribute(this.runnableKey));
        if (deathTimer != null) {
            deathTimer.dropLoot();
        }
    }

    @EventHandler
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        if (event.getDamager() instanceof Player) {
            Player damager = (Player)event.getDamager();
            ItemStack mainHand = damager.getInventory().getItemInMainHand();
            if (!mainHand.hasItemMeta()) {
                return;
            }
            if (mainHand.getItemMeta().getDisplayName().equalsIgnoreCase(this.soulstealerSwordName) && !damager.hasMetadata(this.respawnKey)) {
                mainHand.setType(Material.PUFFERFISH);
                damager.playSound(damager.getLocation(), Sound.ENTITY_WITCH_CELEBRATE, 1.0f, 1.0f);
                damager.updateInventory();
            }
        }
    }

    @Override
    @KitEvent
    public void onKitPlayerDeath(PlayerDeathEvent event) {
        Player player = event.getEntity();
        KitPlayer kitPlayer = KitApi.getInstance().getPlayer(player);
        if (!player.hasMetadata(this.respawnKey)) {
            Player killer = event.getEntity().getKiller();
            if (killer != null) {
                killer.sendMessage(Localization.INSTANCE.getMessage("soulstealer.killedSoulStealer", ChatUtils.locale((Player)killer)));
            }
            DeathTimer deathTimer = new DeathTimer(kitPlayer, player.getInventory().getContents());
            kitPlayer.putKitAttribute(this.runnableKey, deathTimer);
            deathTimer.runTaskTimer((Plugin)KitApi.getInstance().getPlugin(), 0L, 20L);
            event.setCancelled(true);
        }
    }

    @Override
    public void onPlayerKillsPlayer(KitPlayer killer, KitPlayer dead) {
        killer.getBukkitPlayer().ifPresent(player -> {
            if (player.hasMetadata(this.respawnKey)) {
                player.sendMessage(Localization.INSTANCE.getMessage("soulstealer.revived", ChatUtils.locale((UUID)killer.getUUID())));
                DeathTimer deathTimer = (DeathTimer)((Object)((Object)killer.getKitAttribute(this.runnableKey)));
                deathTimer.stop();
                killer.putKitAttribute(this.runnableKey, null);
            }
        });
    }

    private class DeathTimer
    extends BukkitRunnable {
        private final KitPlayer kitPlayer;
        private final BossBar bossBar;
        private final ItemStack[] items;
        private Location lastLocation;
        private int counter;

        DeathTimer(KitPlayer kitPlayer, ItemStack[] items) {
            this.kitPlayer = kitPlayer;
            this.items = items;
            this.counter = SoulstealerKit.this.effectDuration;
            this.bossBar = Bukkit.createBossBar((String)Localization.INSTANCE.getMessage("soulstealer.bossBar", ChatUtils.locale((UUID)kitPlayer.getUUID())), (BarColor)BarColor.WHITE, (BarStyle)BarStyle.SOLID, (BarFlag[])new BarFlag[0]);
            this.setLastLocation();
            this.init();
        }

        private void init() {
            this.kitPlayer.getBukkitPlayer().ifPresent(player -> {
                player.getInventory().clear();
                player.setMetadata(SoulstealerKit.this.respawnKey, (MetadataValue)new FixedMetadataValue((Plugin)KitApi.getInstance().getPlugin(), (Object)""));
                player.setInvisible(true);
                player.getWorld().getNearbyPlayers(player.getLocation(), 5.0).forEach(p -> p.playSound(player.getLocation(), SoulstealerKit.this.deathSound, 1.0f, 1.0f));
                player.addPotionEffect(new PotionEffect(SoulstealerKit.this.effectOnDeath, SoulstealerKit.this.effectDuration * 20, SoulstealerKit.this.effectAmplifier));
                player.getInventory().addItem(new ItemStack[]{SoulstealerKit.this.firstSword});
            });
            this.bossBar.setProgress(1.0);
            this.kitPlayer.getBukkitPlayer().ifPresent(arg_0 -> ((BossBar)this.bossBar).addPlayer(arg_0));
        }

        private void setLastLocation() {
            this.kitPlayer.getBukkitPlayer().ifPresent(player -> {
                this.lastLocation = player.getLocation();
            });
        }

        void dropLoot() {
            Arrays.stream(this.items).filter(Objects::nonNull).forEach(item -> this.lastLocation.getWorld().dropItem(this.lastLocation, item));
            this.stop();
        }

        void stop() {
            this.kitPlayer.getBukkitPlayer().ifPresent(player -> {
                player.removeMetadata(SoulstealerKit.this.respawnKey, (Plugin)KitApi.getInstance().getPlugin());
                player.setInvisible(false);
                player.removePotionEffect(SoulstealerKit.this.effectOnDeath);
            });
            this.bossBar.removeAll();
            this.cancel();
        }

        public void run() {
            if (this.isCancelled()) {
                return;
            }
            this.setLastLocation();
            if (!this.kitPlayer.isValid()) {
                this.cancel();
                return;
            }
            if (this.counter == 0) {
                this.kitPlayer.getBukkitPlayer().ifPresent(player -> player.setHealth(0.0));
                this.cancel();
                return;
            }
            this.bossBar.setProgress((double)this.counter / (double)SoulstealerKit.this.effectDuration);
            --this.counter;
        }
    }
}

