/*
 * Decompiled with CFR 0.152.
 */
package de.hglabor.plugins.kitapi.kit.kits;

import de.hglabor.plugins.kitapi.KitApi;
import de.hglabor.plugins.kitapi.kit.AbstractKit;
import de.hglabor.plugins.kitapi.kit.events.KitEvent;
import de.hglabor.plugins.kitapi.kit.settings.BetaKit;
import de.hglabor.plugins.kitapi.kit.settings.FloatArg;
import de.hglabor.plugins.kitapi.kit.settings.IntArg;
import de.hglabor.plugins.kitapi.kit.settings.MaterialArg;
import de.hglabor.plugins.kitapi.player.KitPlayer;
import de.hglabor.plugins.kitapi.util.BukkitUtils;
import de.hglabor.utils.noriskutils.TimeConverter;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

@BetaKit
public class ScaffoldKit
extends AbstractKit {
    public static final ScaffoldKit INSTANCE = new ScaffoldKit();
    @FloatArg(min=0.0f)
    private final float cooldown;
    @IntArg
    private final int effectDurationInSeconds;
    @IntArg
    private final int blockRemoveDelayInTicks;
    @MaterialArg
    private final Material scaffoldMaterial = Material.SNOW_BLOCK;
    private final String isScaffolding = "isScaffolding" + this.getName();
    private final String scaffoldingTaskKey = "scaffoldingTask" + this.getName();

    private ScaffoldKit() {
        super("Scaffold", Material.SCAFFOLDING);
        this.cooldown = 30.0f;
        this.effectDurationInSeconds = 10;
        this.blockRemoveDelayInTicks = 20;
        this.setMainKitItem(this.getDisplayMaterial());
    }

    @Override
    public void onDeactivation(KitPlayer kitPlayer) {
        ScaffoldMode task = (ScaffoldMode)((Object)kitPlayer.getKitAttribute(this.scaffoldingTaskKey));
        if (task != null) {
            task.end();
        }
    }

    @Override
    @KitEvent(ignoreCooldown=true)
    public void onPlayerMoveEvent(PlayerMoveEvent event, KitPlayer kitPlayer) {
        Block to;
        if (kitPlayer.getKitAttributeOrDefault(this.isScaffolding, false).booleanValue() && (to = event.getTo().getBlock().getRelative(BlockFace.DOWN)).getType().equals((Object)Material.AIR)) {
            BukkitUtils.playSound(event.getPlayer(), Sound.BLOCK_WOOD_PLACE);
            to.setType(this.scaffoldMaterial);
            BukkitUtils.runTaskLater(() -> {
                if (to.getType().equals((Object)this.scaffoldMaterial)) {
                    to.setType(Material.AIR);
                }
            }, this.blockRemoveDelayInTicks);
        }
    }

    @Override
    @KitEvent
    public void onPlayerRightClickKitItem(PlayerInteractEvent event, KitPlayer kitPlayer) {
        if (!kitPlayer.getKitAttributeOrDefault(this.isScaffolding, false).booleanValue()) {
            ScaffoldMode scaffoldMode = new ScaffoldMode(kitPlayer, event.getPlayer());
            scaffoldMode.runTaskTimer((Plugin)KitApi.getInstance().getPlugin(), 0L, 20L);
            kitPlayer.putKitAttribute(this.scaffoldingTaskKey, scaffoldMode);
        }
    }

    @Override
    public float getCooldown() {
        return this.cooldown;
    }

    private class ScaffoldMode
    extends BukkitRunnable {
        private final KitPlayer kitPlayer;
        private final Player player;
        private int counter;

        private ScaffoldMode(KitPlayer kitPlayer, Player player) {
            this.kitPlayer = kitPlayer;
            this.player = player;
            this.init();
        }

        private void init() {
            this.kitPlayer.putKitAttribute(ScaffoldKit.this.isScaffolding, true);
            this.player.sendMessage(ChatColor.GREEN + "Scaffolding activated!");
        }

        public void run() {
            int timeLeft = ScaffoldKit.this.effectDurationInSeconds - this.counter;
            if (this.counter >= ScaffoldKit.this.effectDurationInSeconds || !this.kitPlayer.isValid()) {
                this.end();
                return;
            }
            this.player.sendActionBar("Scaffolding endet in: " + TimeConverter.stringify((int)timeLeft));
            ++this.counter;
        }

        public void end() {
            this.cancel();
            this.player.sendMessage(ChatColor.RED + "Scaffolding wurde deaktiviert!");
            this.kitPlayer.putKitAttribute(ScaffoldKit.this.isScaffolding, false);
            this.kitPlayer.putKitAttribute(ScaffoldKit.this.scaffoldingTaskKey, null);
            this.kitPlayer.activateKitCooldown(ScaffoldKit.this);
        }
    }
}

